/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import java.util.ArrayList;
import java.util.List;

public class RankConfig
extends AutoUpdateConfigLoader {
    private static RankConfig instance;

    public RankConfig() {
        super("skillranks.yml");
        this.validate();
        instance = this;
    }

    @Override
    protected void loadKeys() {
    }

    public static RankConfig getInstance() {
        if (instance == null) {
            return new RankConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.checkKeys(arrayList);
        return this.noErrorsInConfig(arrayList);
    }

    public int getSubSkillUnlockLevel(SubSkillType subSkillType, int n) {
        String string = subSkillType.getRankConfigAddress();
        return this.findRankByRootAddress(n, string);
    }

    public int getSubSkillUnlockLevel(AbstractSubSkill abstractSubSkill, int n) {
        String string = abstractSubSkill.getPrimaryKeyName() + "." + abstractSubSkill.getConfigKeyName();
        return this.findRankByRootAddress(n, string);
    }

    private int findRankByRootAddress(int n, String string) {
        String string2 = Config.getInstance().getIsRetroMode() ? ".RetroMode." : ".Standard.";
        String string3 = "Rank_" + n;
        string = string + string2;
        string = string + string3;
        return this.config.getInt(string);
    }

    private void checkKeys(List<String> list) {
        for (SubSkillType subSkillType : SubSkillType.values()) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < subSkillType.getNumRanks(); ++i) {
                if (n > 0) {
                    n2 = n;
                }
                if ((n = this.getSubSkillUnlockLevel(subSkillType, i)) < 0) {
                    list.add(subSkillType.getAdvConfigAddress() + ".Rank_Levels.Rank_" + n + ".LevelReq should be above or equal to 0!");
                }
                if (n2 <= n) continue;
                plugin.getLogger().info("You have the ranks for the subskill " + subSkillType.toString() + " set up poorly, sequential ranks should have ascending requirements");
            }
        }
    }
}

