/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.mcMMO;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;

public class AdvancedConfig
extends AutoUpdateConfigLoader {
    private static AdvancedConfig instance;

    private AdvancedConfig() {
        super("advanced.yml");
        this.validate();
    }

    public static AdvancedConfig getInstance() {
        if (instance == null) {
            instance = new AdvancedConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getAbilityLength() < 1) {
            arrayList.add("Skills.General.Ability.Length.<mode>.IncreaseLevel should be at least 1!");
        }
        if (this.getEnchantBuff() < 1) {
            arrayList.add("Skills.General.Ability.EnchantBuff should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.ACROBATICS_DODGE) < 1.0) {
            arrayList.add("Skills.Acrobatics.Dodge.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.ACROBATICS_DODGE) < 1) {
            arrayList.add("Skills.Acrobatics.Dodge.MaxBonusLevel should be at least 1!");
        }
        if (this.getDodgeDamageModifier() <= 1.0) {
            arrayList.add("Skills.Acrobatics.Dodge.DamageModifier should be greater than 1!");
        }
        if (this.getMaximumProbability(SubSkillType.ACROBATICS_ROLL) < 1.0) {
            arrayList.add("Skills.Acrobatics.Roll.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.ACROBATICS_ROLL) < 1) {
            arrayList.add("Skills.Acrobatics.Roll.MaxBonusLevel should be at least 1!");
        }
        if (this.getRollDamageThreshold() < 0.0) {
            arrayList.add("Skills.Acrobatics.Roll.DamageThreshold should be at least 0!");
        }
        if (this.getGracefulRollDamageThreshold() < 0.0) {
            arrayList.add("Skills.Acrobatics.GracefulRoll.DamageThreshold should be at least 0!");
        }
        if (this.getCatalysisMinSpeed() <= 0.0) {
            arrayList.add("Skills.Alchemy.Catalysis.MinSpeed must be greater than 0!");
        }
        if (this.getCatalysisMaxSpeed() < this.getCatalysisMinSpeed()) {
            arrayList.add("Skills.Alchemy.Catalysis.MaxSpeed should be at least Skills.Alchemy.Catalysis.MinSpeed!");
        }
        if (this.getSkillShotRankDamageMultiplier() <= 0.0) {
            arrayList.add("Skills.Archery.SkillShot.RankDamageMultiplier should be greater than 0!");
        }
        if (this.getMaximumProbability(SubSkillType.ARCHERY_DAZE) < 1.0) {
            arrayList.add("Skills.Archery.Daze.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.ARCHERY_DAZE) < 1) {
            arrayList.add("Skills.Archery.Daze.MaxBonusLevel should be at least 1!");
        }
        if (this.getDazeBonusDamage() < 0.0) {
            arrayList.add("Skills.Archery.Daze.BonusDamage should be at least 0!");
        }
        if (this.getMaximumProbability(SubSkillType.ARCHERY_ARROW_RETRIEVAL) < 1.0) {
            arrayList.add("Skills.Archery.Retrieve.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.ARCHERY_ARROW_RETRIEVAL) < 1) {
            arrayList.add("Skills.Archery.Retrieve.MaxBonusLevel should be at least 1!");
        }
        if (this.getForceMultiplier() < 0.0) {
            arrayList.add("Skills.Archery.ForceMultiplier should be at least 0!");
        }
        if (this.getAxeMasteryRankDamageMultiplier() < 0.0) {
            arrayList.add("Skills.Axes.AxeMastery.RankDamageMultiplier should be at least 0!");
        }
        if (this.getMaximumProbability(SubSkillType.AXES_CRITICAL_STRIKES) < 1.0) {
            arrayList.add("Skills.Axes.CriticalHit.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.AXES_CRITICAL_STRIKES) < 1) {
            arrayList.add("Skills.Axes.CriticalHit.MaxBonusLevel should be at least 1!");
        }
        if (this.getCriticalStrikesPVPModifier() < 1.0) {
            arrayList.add("Skills.Axes.CriticalStrikes.PVP_Modifier should be at least 1!");
        }
        if (this.getCriticalStrikesPVPModifier() < 1.0) {
            arrayList.add("Skills.Axes.CriticalStrikes.PVE_Modifier should be at least 1!");
        }
        if (this.getGreaterImpactChance() < 1.0) {
            arrayList.add("Skills.Axes.GreaterImpact.Chance should be at least 1!");
        }
        if (this.getGreaterImpactModifier() < 1.0) {
            arrayList.add("Skills.Axes.GreaterImpact.KnockbackModifier should be at least 1!");
        }
        if (this.getGreaterImpactBonusDamage() < 1.0) {
            arrayList.add("Skills.Axes.GreaterImpact.BonusDamage should be at least 1!");
        }
        if (this.getImpactChance() < 1.0) {
            arrayList.add("Skills.Axes.ArmorImpact.Chance should be at least 1!");
        }
        if (this.getSkullSplitterModifier() < 1.0) {
            arrayList.add("Skills.Axes.SkullSplitter.DamageModifier should be at least 1!");
        }
        if (this.getFishermanDietRankChange() < 1) {
            arrayList.add("Skills.Fishing.FishermansDiet.RankChange should be at least 1!");
        }
        if (this.getMasterAnglerBoatModifier() < 1.0) {
            arrayList.add("Skills.Fishing.MasterAngler.BoatModifier should be at least 1!");
        }
        if (this.getMasterAnglerBiomeModifier() < 1.0) {
            arrayList.add("Skills.Fishing.MasterAngler.BiomeModifier should be at least 1!");
        }
        if (this.getFarmerDietRankChange() < 1) {
            arrayList.add("Skills.Herbalism.FarmersDiet.RankChange should be at least 1!");
        }
        if (this.getGreenThumbStageChange() < 1) {
            arrayList.add("Skills.Herbalism.GreenThumb.StageChange should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.HERBALISM_GREEN_THUMB) < 1.0) {
            arrayList.add("Skills.Herbalism.GreenThumb.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.HERBALISM_GREEN_THUMB) < 1) {
            arrayList.add("Skills.Herbalism.GreenThumb.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.HERBALISM_DOUBLE_DROPS) < 1.0) {
            arrayList.add("Skills.Herbalism.DoubleDrops.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.HERBALISM_DOUBLE_DROPS) < 1) {
            arrayList.add("Skills.Herbalism.DoubleDrops.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.HERBALISM_HYLIAN_LUCK) < 1.0) {
            arrayList.add("Skills.Herbalism.HylianLuck.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.HERBALISM_HYLIAN_LUCK) < 1) {
            arrayList.add("Skills.Herbalism.HylianLuck.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.HERBALISM_SHROOM_THUMB) < 1.0) {
            arrayList.add("Skills.Herbalism.ShroomThumb.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.HERBALISM_SHROOM_THUMB) < 1) {
            arrayList.add("Skills.Herbalism.ShroomThumb.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.MINING_DOUBLE_DROPS) < 1.0) {
            arrayList.add("Skills.Mining.DoubleDrops.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.MINING_DOUBLE_DROPS) < 1) {
            arrayList.add("Skills.Mining.DoubleDrops.MaxBonusLevel should be at least 1!");
        }
        if (this.getRepairMasteryMaxBonus() < 1.0) {
            arrayList.add("Skills.Repair.RepairMastery.MaxBonusPercentage should be at least 1!");
        }
        if (this.getRepairMasteryMaxLevel() < 1) {
            arrayList.add("Skills.Repair.RepairMastery.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.REPAIR_SUPER_REPAIR) < 1.0) {
            arrayList.add("Skills.Repair.SuperRepair.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.REPAIR_SUPER_REPAIR) < 1) {
            arrayList.add("Skills.Repair.SuperRepair.MaxBonusLevel should be at least 1!");
        }
        if (this.getBurnModifierMaxLevel() < 1) {
            arrayList.add("Skills.Smelting.FuelEfficiency.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.SMELTING_SECOND_SMELT) < 1) {
            arrayList.add("Skills.Smelting.SecondSmelt.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.SMELTING_SECOND_SMELT) < 1.0) {
            arrayList.add("Skills.Smelting.SecondSmelt.ChanceMax should be at least 1!");
        }
        if (this.getFluxMiningChance() < 1.0) {
            arrayList.add("Skills.Smelting.FluxMining.Chance should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.SWORDS_RUPTURE) < 1.0) {
            arrayList.add("Skills.Swords.Rupture.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.SWORDS_RUPTURE) < 1) {
            arrayList.add("Skills.Swords.Rupture.MaxBonusLevel should be at least 1!");
        }
        if (this.getRuptureMaxTicks() < 1) {
            arrayList.add("Skills.Swords.Rupture.MaxTicks should be at least 1!");
        }
        if (this.getRuptureMaxTicks() < this.getRuptureBaseTicks()) {
            arrayList.add("Skills.Swords.Rupture.MaxTicks should be at least Skills.Swords.Rupture.BaseTicks!");
        }
        if (this.getRuptureBaseTicks() < 1) {
            arrayList.add("Skills.Swords.Rupture.BaseTicks should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.SWORDS_COUNTER_ATTACK) < 1.0) {
            arrayList.add("Skills.Swords.CounterAttack.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.SWORDS_COUNTER_ATTACK) < 1) {
            arrayList.add("Skills.Swords.CounterAttack.MaxBonusLevel should be at least 1!");
        }
        if (this.getCounterModifier() < 1.0) {
            arrayList.add("Skills.Swords.CounterAttack.DamageModifier should be at least 1!");
        }
        if (this.getSerratedStrikesModifier() < 1.0) {
            arrayList.add("Skills.Swords.SerratedStrikes.DamageModifier should be at least 1!");
        }
        if (this.getSerratedStrikesTicks() < 1) {
            arrayList.add("Skills.Swords.SerratedStrikes.RuptureTicks should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.TAMING_GORE) < 1.0) {
            arrayList.add("Skills.Taming.Gore.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.TAMING_GORE) < 1) {
            arrayList.add("Skills.Taming.Gore.MaxBonusLevel should be at least 1!");
        }
        if (this.getGoreModifier() < 1.0) {
            arrayList.add("Skills.Taming.Gore.Modifier should be at least 1!");
        }
        if (this.getFastFoodChance() < 1.0) {
            arrayList.add("Skills.Taming.FastFood.Chance should be at least 1!");
        }
        if (this.getThickFurModifier() < 1.0) {
            arrayList.add("Skills.Taming.ThickFur.Modifier should be at least 1!");
        }
        if (this.getShockProofModifier() < 1.0) {
            arrayList.add("Skills.Taming.ShockProof.Modifier should be at least 1!");
        }
        if (this.getSharpenedClawsBonus() < 1.0) {
            arrayList.add("Skills.Taming.SharpenedClaws.Bonus should be at least 1!");
        }
        if (this.getMaxHorseJumpStrength() < 0.0 || this.getMaxHorseJumpStrength() > 2.0) {
            arrayList.add("Skills.Taming.CallOfTheWild.MaxHorseJumpStrength should be between 0 and 2!");
        }
        if (this.getMaximumProbability(SubSkillType.UNARMED_DISARM) < 1.0) {
            arrayList.add("Skills.Unarmed.Disarm.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.UNARMED_DISARM) < 1) {
            arrayList.add("Skills.Unarmed.Disarm.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.UNARMED_ARROW_DEFLECT) < 1.0) {
            arrayList.add("Skills.Unarmed.ArrowDeflect.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.UNARMED_ARROW_DEFLECT) < 1) {
            arrayList.add("Skills.Unarmed.ArrowDeflect.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.UNARMED_IRON_GRIP) < 1.0) {
            arrayList.add("Skills.Unarmed.IronGrip.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.UNARMED_IRON_GRIP) < 1) {
            arrayList.add("Skills.Unarmed.IronGrip.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaximumProbability(SubSkillType.WOODCUTTING_HARVEST_LUMBER) < 1.0) {
            arrayList.add("Skills.Woodcutting.HarvestLumber.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SubSkillType.WOODCUTTING_HARVEST_LUMBER) < 1) {
            arrayList.add("Skills.Woodcutting.HarvestLumber.MaxBonusLevel should be at least 1!");
        }
        if (this.getKrakenTriesBeforeRelease() < 1) {
            arrayList.add("Kraken.Tries_Before_Release should be at least 1!");
        }
        if (this.getKrakenHealth() < 1.0) {
            arrayList.add("Kraken.Health should be at least 1!");
        }
        if (this.getKrakenAttackInterval() < 1) {
            arrayList.add("Kraken.Attack_Interval_Seconds should be at least 1!");
        }
        if (this.getKrakenAttackDamage() < 1.0) {
            arrayList.add("Kraken.Attack_Damage should be at least 1!");
        }
        return this.noErrorsInConfig(arrayList);
    }

    @Override
    protected void loadKeys() {
    }

    public boolean canApplyLimitBreakPVE() {
        return this.config.getBoolean("Skills.General.LimitBreak.AllowPVE", false);
    }

    public int getStartingLevel() {
        return this.config.getInt("Skills.General.StartingLevel", 1);
    }

    public boolean allowPlayerTips() {
        return this.config.getBoolean("Feedback.PlayerTips", true);
    }

    public int getAbilityLengthCap() {
        if (!mcMMO.isRetroModeEnabled()) {
            return this.config.getInt("Skills.General.Ability.Length.Standard.CapLevel", 50);
        }
        return this.config.getInt("Skills.General.Ability.Length.RetroMode.CapLevel", 500);
    }

    public int getAbilityLength() {
        if (!mcMMO.isRetroModeEnabled()) {
            return this.config.getInt("Skills.General.Ability.Length.Standard.IncreaseLevel", 5);
        }
        return this.config.getInt("Skills.General.Ability.Length.RetroMode.IncreaseLevel", 50);
    }

    public int getEnchantBuff() {
        return this.config.getInt("Skills.General.Ability.EnchantBuff", 5);
    }

    public int getMaxBonusLevel(SubSkillType subSkillType) {
        String string = subSkillType.getAdvConfigAddress() + ".MaxBonusLevel.";
        return mcMMO.isRetroModeEnabled() ? this.config.getInt(string + "RetroMode", 1000) : this.config.getInt(string + "Standard", 100);
    }

    public int getMaxBonusLevel(AbstractSubSkill abstractSubSkill) {
        return this.getMaxBonusLevel(abstractSubSkill.getSubSkillType());
    }

    public double getMaximumProbability(SubSkillType subSkillType) {
        double d = this.config.getDouble(subSkillType.getAdvConfigAddress() + ".ChanceMax", 100.0);
        return d;
    }

    public double getMaximumProbability(AbstractSubSkill abstractSubSkill) {
        return this.getMaximumProbability(abstractSubSkill.getSubSkillType());
    }

    public boolean doesSkillCommandSendBlankLines() {
        return this.config.getBoolean("Feedback.SkillCommand.BlankLinesAboveHeader", true);
    }

    public boolean doesNotificationUseActionBar(NotificationType notificationType) {
        return this.config.getBoolean("Feedback.ActionBarNotifications." + notificationType.toString() + ".Enabled", true);
    }

    public boolean doesNotificationSendCopyToChat(NotificationType notificationType) {
        return this.config.getBoolean("Feedback.ActionBarNotifications." + notificationType.toString() + ".SendCopyOfMessageToChat", false);
    }

    public boolean useTitlesForXPEvent() {
        return this.config.getBoolean("Feedback.Events.XP.SendTitles", true);
    }

    private ChatColor getChatColorFromKey(String string) {
        String string2 = this.config.getString(string);
        return this.getChatColor(string2);
    }

    private ChatColor getChatColor(String string) {
        for (ChatColor chatColor : ChatColor.values()) {
            if (!string.equalsIgnoreCase(chatColor.getName())) continue;
            return chatColor;
        }
        System.out.println("[mcMMO] " + string + " is an invalid color value");
        return ChatColor.WHITE;
    }

    public boolean isSubSkillClassic(SubSkillType subSkillType) {
        return this.config.getBoolean(subSkillType.getAdvConfigAddress() + ".Classic");
    }

    public double getDodgeDamageModifier() {
        return this.config.getDouble("Skills.Acrobatics.Dodge.DamageModifier", 2.0);
    }

    public double getRollDamageThreshold() {
        return this.config.getDouble("Skills.Acrobatics.Roll.DamageThreshold", 7.0);
    }

    public double getGracefulRollDamageThreshold() {
        return this.config.getDouble("Skills.Acrobatics.GracefulRoll.DamageThreshold", 14.0);
    }

    public int getCatalysisMaxBonusLevel() {
        return this.config.getInt("Skills.Alchemy.Catalysis.MaxBonusLevel", 1000);
    }

    public double getCatalysisMinSpeed() {
        return this.config.getDouble("Skills.Alchemy.Catalysis.MinSpeed", 1.0);
    }

    public double getCatalysisMaxSpeed() {
        return this.config.getDouble("Skills.Alchemy.Catalysis.MaxSpeed", 4.0);
    }

    public double getSkillShotRankDamageMultiplier() {
        return this.config.getDouble("Skills.Archery.SkillShot.RankDamageMultiplier", 10.0);
    }

    public double getSkillShotDamageMax() {
        return this.config.getDouble("Skills.Archery.SkillShot.MaxDamage", 9.0);
    }

    public double getDazeBonusDamage() {
        return this.config.getDouble("Skills.Archery.Daze.BonusDamage", 4.0);
    }

    public double getForceMultiplier() {
        return this.config.getDouble("Skills.Archery.ForceMultiplier", 2.0);
    }

    public double getAxeMasteryRankDamageMultiplier() {
        return this.config.getDouble("Skills.Axes.AxeMastery.RankDamageMultiplier", 1.0);
    }

    public double getCriticalStrikesPVPModifier() {
        return this.config.getDouble("Skills.Axes.CriticalStrikes.PVP_Modifier", 1.5);
    }

    public double getCriticalStrikesPVEModifier() {
        return this.config.getDouble("Skills.Axes.CriticalStrikes.PVE_Modifier", 2.0);
    }

    public double getGreaterImpactChance() {
        return this.config.getDouble("Skills.Axes.GreaterImpact.Chance", 25.0);
    }

    public double getGreaterImpactModifier() {
        return this.config.getDouble("Skills.Axes.GreaterImpact.KnockbackModifier", 1.5);
    }

    public double getGreaterImpactBonusDamage() {
        return this.config.getDouble("Skills.Axes.GreaterImpact.BonusDamage", 2.0);
    }

    public double getImpactChance() {
        return this.config.getDouble("Skills.Axes.ArmorImpact.Chance", 25.0);
    }

    public double getImpactDurabilityDamageMultiplier() {
        return this.config.getDouble("Skills.Axes.ArmorImpact.DamagePerRank", 6.5);
    }

    public double getSkullSplitterModifier() {
        return this.config.getDouble("Skills.Axes.SkullSplitter.DamageModifier", 2.0);
    }

    public double getShakeChance(int n) {
        return this.config.getDouble("Skills.Fishing.ShakeChance.Rank_" + n);
    }

    public int getFishingVanillaXPModifier(int n) {
        return this.config.getInt("Skills.Fishing.VanillaXPMultiplier.Rank_" + n);
    }

    public int getFishermanDietRankChange() {
        return this.config.getInt("Skills.Fishing.FishermansDiet.RankChange", 200);
    }

    public double getMasterAnglerBoatModifier() {
        return this.config.getDouble("Skills.Fishing.MasterAngler.BoatModifier", 2.0);
    }

    public double getMasterAnglerBiomeModifier() {
        return this.config.getDouble("Skills.Fishing.MasterAngler.BiomeModifier", 2.0);
    }

    public int getFarmerDietRankChange() {
        return this.config.getInt("Skills.Herbalism.FarmersDiet.RankChange", 200);
    }

    public int getGreenThumbStageChange() {
        return this.config.getInt("Skills.Herbalism.GreenThumb.StageChange", 200);
    }

    public boolean getDoubleDropSilkTouchEnabled() {
        return this.config.getBoolean("Skills.Mining.DoubleDrops.SilkTouch", true);
    }

    public int getBlastMiningRankLevel(int n) {
        return this.config.getInt("Skills.Mining.BlastMining.Rank_Levels.Rank_" + n);
    }

    public double getBlastDamageDecrease(int n) {
        return this.config.getDouble("Skills.Mining.BlastMining.BlastDamageDecrease.Rank_" + n);
    }

    public double getOreBonus(int n) {
        return this.config.getDouble("Skills.Mining.BlastMining.OreBonus.Rank_" + n);
    }

    public double getDebrisReduction(int n) {
        return this.config.getDouble("Skills.Mining.BlastMining.DebrisReduction.Rank_" + n);
    }

    public int getDropMultiplier(int n) {
        return this.config.getInt("Skills.Mining.BlastMining.DropMultiplier.Rank_" + n);
    }

    public double getBlastRadiusModifier(int n) {
        return this.config.getDouble("Skills.Mining.BlastMining.BlastRadiusModifier.Rank_" + n);
    }

    public double getRepairMasteryMaxBonus() {
        return this.config.getDouble("Skills.Repair.RepairMastery.MaxBonusPercentage", 200.0);
    }

    public int getRepairMasteryMaxLevel() {
        return this.config.getInt("Skills.Repair.RepairMastery.MaxBonusLevel", 100);
    }

    public boolean getArcaneForgingEnchantLossEnabled() {
        return this.config.getBoolean("Skills.Repair.ArcaneForging.May_Lose_Enchants", true);
    }

    public double getArcaneForgingKeepEnchantsChance(int n) {
        return this.config.getDouble("Skills.Repair.ArcaneForging.Keep_Enchants_Chance.Rank_" + n);
    }

    public boolean getArcaneForgingDowngradeEnabled() {
        return this.config.getBoolean("Skills.Repair.ArcaneForging.Downgrades_Enabled", true);
    }

    public double getArcaneForgingDowngradeChance(int n) {
        return this.config.getDouble("Skills.Repair.ArcaneForging.Downgrades_Chance.Rank_" + n);
    }

    public boolean getArcaneSalvageEnchantDowngradeEnabled() {
        return this.config.getBoolean("Skills.Salvage.ArcaneSalvage.EnchantDowngradeEnabled", true);
    }

    public boolean getArcaneSalvageEnchantLossEnabled() {
        return this.config.getBoolean("Skills.Salvage.ArcaneSalvage.EnchantLossEnabled", true);
    }

    public double getArcaneSalvageExtractFullEnchantsChance(int n) {
        return this.config.getDouble("Skills.Salvage.ArcaneSalvage.ExtractFullEnchant.Rank_" + n);
    }

    public double getArcaneSalvageExtractPartialEnchantsChance(int n) {
        return this.config.getDouble("Skills.Salvage.ArcaneSalvage.ExtractPartialEnchant.Rank_" + n);
    }

    public int getBurnModifierMaxLevel() {
        if (mcMMO.isRetroModeEnabled()) {
            return this.config.getInt("Skills.Smelting.FuelEfficiency.RetroMode.MaxBonusLevel", 1000);
        }
        return this.config.getInt("Skills.Smelting.FuelEfficiency.Standard.MaxBonusLevel", 100);
    }

    public double getFluxMiningChance() {
        return this.config.getDouble("Skills.Smelting.FluxMining.Chance", 33.0);
    }

    public int getSmeltingRankLevel(int n) {
        return this.config.getInt("Skills.Smelting.Rank_Levels.Rank_" + n);
    }

    public int getSmeltingVanillaXPBoostMultiplier(int n) {
        return this.config.getInt("Skills.Smelting.VanillaXPMultiplier.Rank_" + n);
    }

    public double getRuptureDamagePlayer() {
        return this.config.getDouble("Skills.Swords.Rupture.DamagePlayer", 1.0);
    }

    public double getRuptureDamageMobs() {
        return this.config.getDouble("Skills.Swords.Rupture.DamageMobs", 2.0);
    }

    public int getRuptureMaxTicks() {
        return this.config.getInt("Skills.Swords.Rupture.MaxTicks", 8);
    }

    public int getRuptureBaseTicks() {
        return this.config.getInt("Skills.Swords.Rupture.BaseTicks", 2);
    }

    public double getCounterModifier() {
        return this.config.getDouble("Skills.Swords.CounterAttack.DamageModifier", 2.0);
    }

    public double getSerratedStrikesModifier() {
        return this.config.getDouble("Skills.Swords.SerratedStrikes.DamageModifier", 4.0);
    }

    public int getSerratedStrikesTicks() {
        return this.config.getInt("Skills.Swords.SerratedStrikes.RuptureTicks", 5);
    }

    public double getGoreModifier() {
        return this.config.getDouble("Skills.Taming.Gore.Modifier", 2.0);
    }

    public double getFastFoodChance() {
        return this.config.getDouble("Skills.Taming.FastFoodService.Chance", 50.0);
    }

    public double getPummelChance() {
        return this.config.getDouble("Skills.Taming.Pummel.Chance", 10.0);
    }

    public double getThickFurModifier() {
        return this.config.getDouble("Skills.Taming.ThickFur.Modifier", 2.0);
    }

    public double getShockProofModifier() {
        return this.config.getDouble("Skills.Taming.ShockProof.Modifier", 6.0);
    }

    public double getSharpenedClawsBonus() {
        return this.config.getDouble("Skills.Taming.SharpenedClaws.Bonus", 2.0);
    }

    public double getMinHorseJumpStrength() {
        return this.config.getDouble("Skills.Taming.CallOfTheWild.MinHorseJumpStrength", 0.7);
    }

    public double getMaxHorseJumpStrength() {
        return this.config.getDouble("Skills.Taming.CallOfTheWild.MaxHorseJumpStrength", 2.0);
    }

    public boolean getDisarmProtected() {
        return this.config.getBoolean("Skills.Unarmed.Disarm.AntiTheft", false);
    }

    public boolean getKrakenEnabled() {
        return this.config.getBoolean("Kraken.Enabled", true);
    }

    public int getKrakenTriesBeforeRelease() {
        return this.config.getInt("Kraken.Tries_Before_Release", 50);
    }

    public double getKrakenHealth() {
        return this.config.getDouble("Kraken.Health", 50.0);
    }

    public String getKrakenName() {
        return this.config.getString("Kraken.Name", "The Kraken");
    }

    public int getKrakenAttackInterval() {
        return this.config.getInt("Kraken.Attack_Interval_Seconds", 1);
    }

    public double getKrakenAttackDamage() {
        return this.config.getDouble("Kraken.Attack_Damage", 1.0);
    }

    public boolean getKrakenGlobalEffectsEnabled() {
        return this.config.getBoolean("Kraken.Global_Effects", false);
    }

    public boolean getKrakenEscapeAllowed() {
        return this.config.getBoolean("Kraken.Allow_Escaping", false);
    }

    public String getServerUnleashMessage() {
        return this.config.getString("Kraken.Unleashed_Message.Server", "");
    }

    public String getPlayerUnleashMessage() {
        return this.config.getString("Kraken.Unleashed_Message.Player", "");
    }

    public String getPlayerDefeatMessage() {
        return this.config.getString("Kraken.Defeated_Message.Killed", "");
    }

    public String getPlayerEscapeMessage() {
        return this.config.getString("Kraken.Defeated_Message.Escape", "");
    }
}

