/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class WoodcuttingCommand
extends SkillCommand {
    private String treeFellerLength;
    private String treeFellerLengthEndurance;
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private boolean canTreeFell;
    private boolean canLeafBlow;
    private boolean canDoubleDrop;
    private boolean canSplinter;
    private boolean canBarkSurgeon;
    private boolean canNaturesBounty;

    public WoodcuttingCommand() {
        super(PrimarySkillType.WOODCUTTING);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        if (this.canDoubleDrop) {
            this.setDoubleDropClassicChanceStrings(player);
        }
        if (this.canTreeFell) {
            String[] stringArray = this.calculateLengthDisplayValues(player, f);
            this.treeFellerLength = stringArray[0];
            this.treeFellerLengthEndurance = stringArray[1];
        }
    }

    private void setDoubleDropClassicChanceStrings(Player player) {
        String[] stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.WOODCUTTING_HARVEST_LUMBER);
        this.doubleDropChance = stringArray[0];
        this.doubleDropChanceLucky = stringArray[1];
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canTreeFell = RankUtils.hasUnlockedSubskill(player, SubSkillType.WOODCUTTING_TREE_FELLER) && Permissions.treeFeller((Permissible)player);
        this.canDoubleDrop = this.canUseSubskill(player, SubSkillType.WOODCUTTING_HARVEST_LUMBER) && !this.skill.getDoubleDropsDisabled() && RankUtils.getRank(player, SubSkillType.WOODCUTTING_HARVEST_LUMBER) >= 1;
        this.canLeafBlow = this.canUseSubskill(player, SubSkillType.WOODCUTTING_LEAF_BLOWER);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canDoubleDrop) {
            arrayList.add(this.getStatMessage(SubSkillType.WOODCUTTING_HARVEST_LUMBER, this.doubleDropChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canLeafBlow) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Woodcutting.Ability.0"), LocaleLoader.getString("Woodcutting.Ability.1")));
        }
        if (this.canTreeFell) {
            arrayList.add(this.getStatMessage(SubSkillType.WOODCUTTING_TREE_FELLER, this.treeFellerLength) + (bl ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.treeFellerLengthEndurance) : ""));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.WOODCUTTING);
        return arrayList;
    }
}

