/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class UnarmedCommand
extends SkillCommand {
    private String berserkLength;
    private String berserkLengthEndurance;
    private String deflectChance;
    private String deflectChanceLucky;
    private String disarmChance;
    private String disarmChanceLucky;
    private String ironGripChance;
    private String ironGripChanceLucky;
    private double ironArmBonus;
    private boolean canBerserk;
    private boolean canDisarm;
    private boolean canIronArm;
    private boolean canDeflect;
    private boolean canIronGrip;

    public UnarmedCommand() {
        super(PrimarySkillType.UNARMED);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        String[] stringArray;
        if (this.canDeflect) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.UNARMED_ARROW_DEFLECT);
            this.deflectChance = stringArray[0];
            this.deflectChanceLucky = stringArray[1];
        }
        if (this.canBerserk) {
            stringArray = this.calculateLengthDisplayValues(player, f);
            this.berserkLength = stringArray[0];
            this.berserkLengthEndurance = stringArray[1];
        }
        if (this.canDisarm) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.UNARMED_DISARM);
            this.disarmChance = stringArray[0];
            this.disarmChanceLucky = stringArray[1];
        }
        if (this.canIronArm) {
            this.ironArmBonus = UserManager.getPlayer(player).getUnarmedManager().getIronArmDamage();
        }
        if (this.canIronGrip) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.UNARMED_IRON_GRIP);
            this.ironGripChance = stringArray[0];
            this.ironGripChanceLucky = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBerserk = RankUtils.hasUnlockedSubskill(player, SubSkillType.UNARMED_BERSERK) && Permissions.berserk((Permissible)player);
        this.canIronArm = this.canUseSubskill(player, SubSkillType.UNARMED_IRON_ARM_STYLE);
        this.canDeflect = this.canUseSubskill(player, SubSkillType.UNARMED_ARROW_DEFLECT);
        this.canDisarm = this.canUseSubskill(player, SubSkillType.UNARMED_DISARM);
        this.canIronGrip = this.canUseSubskill(player, SubSkillType.UNARMED_IRON_GRIP);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canDeflect) {
            arrayList.add(this.getStatMessage(SubSkillType.UNARMED_ARROW_DEFLECT, this.deflectChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.deflectChanceLucky) : ""));
        }
        if (this.canBerserk) {
            arrayList.add(this.getStatMessage(SubSkillType.UNARMED_BERSERK, this.berserkLength) + (bl ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.berserkLengthEndurance) : ""));
        }
        if (this.canDisarm) {
            arrayList.add(this.getStatMessage(SubSkillType.UNARMED_DISARM, this.disarmChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.disarmChanceLucky) : ""));
        }
        if (this.canIronArm) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Unarmed.Ability.Bonus.0"), LocaleLoader.getString("Unarmed.Ability.Bonus.1", this.ironArmBonus)));
        }
        if (this.canIronGrip) {
            arrayList.add(this.getStatMessage(SubSkillType.UNARMED_IRON_GRIP, this.ironGripChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.ironGripChanceLucky) : ""));
        }
        if (this.canUseSubskill(player, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK)) {
            arrayList.add(this.getStatMessage(SubSkillType.UNARMED_UNARMED_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK, 1000))));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.UNARMED);
        return arrayList;
    }
}

