/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class TamingCommand
extends SkillCommand {
    private String goreChance;
    private String goreChanceLucky;
    private boolean canBeastLore;
    private boolean canGore;
    private boolean canSharpenedClaws;
    private boolean canEnvironmentallyAware;
    private boolean canThickFur;
    private boolean canShockProof;
    private boolean canCallWild;
    private boolean canFastFood;
    private boolean canHolyHound;

    public TamingCommand() {
        super(PrimarySkillType.TAMING);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        if (this.canGore) {
            String[] stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.TAMING_GORE);
            this.goreChance = stringArray[0];
            this.goreChanceLucky = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBeastLore = this.canUseSubskill(player, SubSkillType.TAMING_BEAST_LORE);
        this.canCallWild = Permissions.callOfTheWild((Permissible)player, EntityType.HORSE) || Permissions.callOfTheWild((Permissible)player, EntityType.WOLF) || Permissions.callOfTheWild((Permissible)player, EntityType.OCELOT);
        this.canEnvironmentallyAware = this.canUseSubskill(player, SubSkillType.TAMING_ENVIRONMENTALLY_AWARE);
        this.canFastFood = this.canUseSubskill(player, SubSkillType.TAMING_FAST_FOOD_SERVICE);
        this.canGore = this.canUseSubskill(player, SubSkillType.TAMING_GORE);
        this.canSharpenedClaws = this.canUseSubskill(player, SubSkillType.TAMING_SHARPENED_CLAWS);
        this.canShockProof = this.canUseSubskill(player, SubSkillType.TAMING_SHOCK_PROOF);
        this.canThickFur = this.canUseSubskill(player, SubSkillType.TAMING_THICK_FUR);
        this.canHolyHound = this.canUseSubskill(player, SubSkillType.TAMING_HOLY_HOUND);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canEnvironmentallyAware) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.0"), LocaleLoader.getString("Taming.Ability.Bonus.1")));
        }
        if (this.canFastFood) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.8"), LocaleLoader.getString("Taming.Ability.Bonus.9", this.percent.format(Taming.fastFoodServiceActivationChance / 100.0))));
        }
        if (this.canGore) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Combat.Chance.Gore"), this.goreChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.goreChanceLucky) : ""));
        }
        if (this.canHolyHound) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.10"), LocaleLoader.getString("Taming.Ability.Bonus.11")));
        }
        if (this.canSharpenedClaws) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.6"), LocaleLoader.getString("Taming.Ability.Bonus.7", Taming.sharpenedClawsBonusDamage)));
        }
        if (this.canShockProof) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.4"), LocaleLoader.getString("Taming.Ability.Bonus.5", Taming.shockProofModifier)));
        }
        if (this.canThickFur) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.2"), LocaleLoader.getString("Taming.Ability.Bonus.3", Taming.thickFurModifier)));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, this.skill);
        return arrayList;
    }
}

