/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class SwordsCommand
extends SkillCommand {
    private String counterChance;
    private String counterChanceLucky;
    private int bleedLength;
    private String bleedChance;
    private String bleedChanceLucky;
    private String serratedStrikesLength;
    private String serratedStrikesLengthEndurance;
    private boolean canCounter;
    private boolean canSerratedStrike;
    private boolean canBleed;

    public SwordsCommand() {
        super(PrimarySkillType.SWORDS);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        String[] stringArray;
        if (this.canCounter) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.SWORDS_COUNTER_ATTACK);
            this.counterChance = stringArray[0];
            this.counterChanceLucky = stringArray[1];
        }
        if (this.canBleed) {
            this.bleedLength = UserManager.getPlayer(player).getSwordsManager().getRuptureBleedTicks();
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.SWORDS_RUPTURE);
            this.bleedChance = stringArray[0];
            this.bleedChanceLucky = stringArray[1];
        }
        if (this.canSerratedStrike) {
            stringArray = this.calculateLengthDisplayValues(player, f);
            this.serratedStrikesLength = stringArray[0];
            this.serratedStrikesLengthEndurance = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBleed = this.canUseSubskill(player, SubSkillType.SWORDS_RUPTURE);
        this.canCounter = this.canUseSubskill(player, SubSkillType.SWORDS_COUNTER_ATTACK);
        this.canSerratedStrike = RankUtils.hasUnlockedSubskill(player, SubSkillType.SWORDS_SERRATED_STRIKES) && Permissions.serratedStrikes((Permissible)player);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        double d;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = UserManager.getPlayer(player).getSwordsManager().getRuptureBleedTicks();
        double d2 = RankUtils.getRank(player, SubSkillType.SWORDS_RUPTURE) >= 3 ? AdvancedConfig.getInstance().getRuptureDamagePlayer() * 1.5 : AdvancedConfig.getInstance().getRuptureDamagePlayer();
        double d3 = d = RankUtils.getRank(player, SubSkillType.SWORDS_RUPTURE) >= 3 ? AdvancedConfig.getInstance().getRuptureDamageMobs() * 1.5 : AdvancedConfig.getInstance().getRuptureDamageMobs();
        if (this.canCounter) {
            arrayList.add(this.getStatMessage(SubSkillType.SWORDS_COUNTER_ATTACK, this.counterChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.counterChanceLucky) : ""));
        }
        if (this.canBleed) {
            arrayList.add(this.getStatMessage(SubSkillType.SWORDS_RUPTURE, this.bleedChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.bleedChanceLucky) : ""));
            arrayList.add(this.getStatMessage(true, true, SubSkillType.SWORDS_RUPTURE, String.valueOf(n), String.valueOf(d2), String.valueOf(d)));
            arrayList.add(LocaleLoader.getString("Swords.Combat.Rupture.Note"));
        }
        if (this.canSerratedStrike) {
            arrayList.add(this.getStatMessage(SubSkillType.SWORDS_SERRATED_STRIKES, this.serratedStrikesLength) + (bl ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.serratedStrikesLengthEndurance) : ""));
        }
        if (this.canUseSubskill(player, SubSkillType.SWORDS_STAB)) {
            arrayList.add(this.getStatMessage(SubSkillType.SWORDS_STAB, String.valueOf(UserManager.getPlayer(player).getSwordsManager().getStabDamage())));
        }
        if (this.canUseSubskill(player, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK)) {
            arrayList.add(this.getStatMessage(SubSkillType.SWORDS_SWORDS_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK, 1000))));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.SWORDS);
        return arrayList;
    }
}

