/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class SmeltingCommand
extends SkillCommand {
    private String burnTimeModifier;
    private String str_secondSmeltChance;
    private String str_secondSmeltChanceLucky;
    private String str_fluxMiningChance;
    private String str_fluxMiningChanceLucky;
    private boolean canFuelEfficiency;
    private boolean canSecondSmelt;
    private boolean canFluxMine;
    private boolean canUnderstandTheArt;

    public SmeltingCommand() {
        super(PrimarySkillType.SMELTING);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        if (this.canFuelEfficiency) {
            this.burnTimeModifier = String.valueOf(UserManager.getPlayer(player).getSmeltingManager().getFuelEfficiencyMultiplier());
        }
        if (this.canSecondSmelt) {
            String[] stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.SMELTING_SECOND_SMELT);
            this.str_secondSmeltChance = stringArray[0];
            this.str_secondSmeltChanceLucky = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canFuelEfficiency = this.canUseSubskill(player, SubSkillType.SMELTING_FUEL_EFFICIENCY);
        this.canSecondSmelt = this.canUseSubskill(player, SubSkillType.SMELTING_SECOND_SMELT);
        this.canUnderstandTheArt = Permissions.vanillaXpBoost((Permissible)player, this.skill) && RankUtils.hasUnlockedSubskill(player, SubSkillType.SMELTING_UNDERSTANDING_THE_ART);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canFuelEfficiency) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.SMELTING_FUEL_EFFICIENCY, this.burnTimeModifier));
        }
        if (this.canSecondSmelt) {
            arrayList.add(this.getStatMessage(SubSkillType.SMELTING_SECOND_SMELT, this.str_secondSmeltChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.str_secondSmeltChanceLucky) : ""));
        }
        if (this.canUnderstandTheArt) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.SMELTING_UNDERSTANDING_THE_ART, String.valueOf(UserManager.getPlayer(player).getSmeltingManager().getVanillaXpMultiplier())));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.SMELTING);
        return arrayList;
    }
}

