/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class SkillGuideCommand
implements CommandExecutor {
    private String header;
    private ArrayList<String> guide;
    private String invalidPage = LocaleLoader.getString("Guides.Page.Invalid");

    public SkillGuideCommand(PrimarySkillType primarySkillType) {
        this.header = LocaleLoader.getString("Guides.Header", primarySkillType.getName());
        this.guide = this.getGuide(primarySkillType);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                if (!stringArray[0].equals("?")) {
                    return false;
                }
                this.sendGuide(commandSender, 1);
                return true;
            }
            case 2: {
                int n = this.getTotalPageNumber();
                if (!StringUtils.isInt(stringArray[1])) {
                    commandSender.sendMessage(this.invalidPage);
                    return true;
                }
                int n2 = Integer.parseInt(stringArray[1]);
                if (n2 > n || n2 <= 0) {
                    commandSender.sendMessage(LocaleLoader.getString("Guides.Page.OutOfRange", n));
                    return true;
                }
                this.sendGuide(commandSender, n2);
                return true;
            }
        }
        return false;
    }

    private int getTotalPageNumber() {
        return (int)Math.ceil((double)this.guide.size() / 8.0);
    }

    private void sendGuide(CommandSender commandSender, int n) {
        for (String string : this.grabPageContents(n)) {
            commandSender.sendMessage(string);
        }
    }

    private ArrayList<String> grabPageContents(int n) {
        int n2 = 8 * (n - 1);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.header);
        while (arrayList.size() < 9) {
            if (n2 + arrayList.size() > this.guide.size()) {
                arrayList.add("");
                continue;
            }
            arrayList.add(this.guide.get(n2 + (arrayList.size() - 1)));
        }
        arrayList.add("Page " + n + " of " + this.getTotalPageNumber());
        return arrayList;
    }

    private ArrayList<String> getGuide(PrimarySkillType primarySkillType) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 10 && !(stringArray = LocaleLoader.getString("Guides." + StringUtils.getCapitalized(primarySkillType.toString()) + ".Section." + i).split("\n"))[0].startsWith("!"); ++i) {
            arrayList.addAll(Arrays.asList(stringArray));
            if (stringArray.length >= 8) continue;
            for (int j = 8 - stringArray.length; j > 0; --j) {
                arrayList.add("");
            }
        }
        return arrayList;
    }
}

