/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillGuideCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public abstract class SkillCommand
implements TabExecutor {
    protected PrimarySkillType skill;
    private String skillName;
    protected DecimalFormat percent = new DecimalFormat("##0.00%");
    protected DecimalFormat decimal = new DecimalFormat("##0.00");
    private CommandExecutor skillGuideCommand;

    public SkillCommand(PrimarySkillType primarySkillType) {
        this.skill = primarySkillType;
        this.skillName = primarySkillType.getName();
        this.skillGuideCommand = new SkillGuideCommand(primarySkillType);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (CommandUtils.noConsoleUsage(commandSender)) {
            return true;
        }
        if (!CommandUtils.hasPlayerDataKey(commandSender)) {
            return true;
        }
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        switch (stringArray.length) {
            case 0: {
                Player player = (Player)commandSender;
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
                boolean bl = Permissions.lucky((Permissible)player, this.skill);
                boolean bl2 = PerksUtils.handleActivationPerks(player, 0, 0) != 0;
                float f = mcMMOPlayer.getSkillLevel(this.skill);
                if (AdvancedConfig.getInstance().doesSkillCommandSendBlankLines()) {
                    for (int i = 0; i < 2; ++i) {
                        player.sendMessage("");
                    }
                }
                this.permissionsCheck(player);
                this.dataCalculations(player, f);
                this.sendSkillCommandHeader(player, mcMMOPlayer, (int)f);
                List<TextComponent> list = this.getTextComponents(player);
                player.sendMessage(LocaleLoader.getString("Skills.Overhaul.Header", LocaleLoader.getString("Effects.SubSkills.Overhaul")));
                TextComponentFactory.sendPlayerSubSkillList(player, list);
                this.getStatMessages(player, bl, bl2, f);
                if (Config.getInstance().getUrlLinksEnabled()) {
                    player.sendMessage(LocaleLoader.getString("Overhaul.mcMMO.Header"));
                    TextComponentFactory.sendPlayerUrlHeader(player);
                }
                if (Config.getInstance().getScoreboardsEnabled() && Config.getInstance().getSkillUseBoard()) {
                    ScoreboardManager.enablePlayerSkillScoreboard(player, this.skill);
                }
                return true;
            }
        }
        return this.skillGuideCommand.onCommand(commandSender, command, string, stringArray);
    }

    private void getStatMessages(Player player, boolean bl, boolean bl2, float f) {
        List<String> list = this.statsDisplay(player, f, bl2, bl);
        if (!list.isEmpty()) {
            player.sendMessage(LocaleLoader.getString("Skills.Overhaul.Header", LocaleLoader.getString("Commands.Stats.Self.Overhaul")));
            for (String string : list) {
                player.sendMessage(string);
            }
        }
        player.sendMessage(LocaleLoader.getString("Guides.Available", this.skillName, this.skillName.toLowerCase()));
    }

    private void sendSkillCommandHeader(Player player, McMMOPlayer mcMMOPlayer, int n) {
        ChatColor chatColor = ChatColor.DARK_AQUA;
        ChatColor chatColor2 = ChatColor.GOLD;
        ChatColor chatColor3 = ChatColor.RED;
        player.sendMessage(LocaleLoader.getString("Skills.Overhaul.Header", this.skillName));
        if (!this.skill.isChildSkill()) {
            player.sendMessage(LocaleLoader.getString("Commands.XPGain.Overhaul", LocaleLoader.getString("Commands.XPGain." + StringUtils.getCapitalized(this.skill.toString()))));
            player.sendMessage(LocaleLoader.getString("Effects.Level.Overhaul", n, mcMMOPlayer.getSkillXpLevel(this.skill), mcMMOPlayer.getXpToLevel(this.skill)));
        } else {
            Set<PrimarySkillType> set = FamilyTree.getParents(this.skill);
            ArrayList<PrimarySkillType> arrayList = new ArrayList<PrimarySkillType>();
            for (PrimarySkillType primarySkillType : set) {
                arrayList.add(primarySkillType);
            }
            Object object = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i + 1 < arrayList.size()) {
                    object = (String)object + LocaleLoader.getString("Effects.Child.ParentList", ((PrimarySkillType)((Object)arrayList.get(i))).getName(), mcMMOPlayer.getSkillLevel((PrimarySkillType)((Object)arrayList.get(i))));
                    object = (String)object + ChatColor.GRAY + ", ";
                    continue;
                }
                object = (String)object + LocaleLoader.getString("Effects.Child.ParentList", ((PrimarySkillType)((Object)arrayList.get(i))).getName(), mcMMOPlayer.getSkillLevel((PrimarySkillType)((Object)arrayList.get(i))));
            }
            player.sendMessage(LocaleLoader.getString("Commands.XPGain.Overhaul", LocaleLoader.getString("Commands.XPGain.Child")));
            player.sendMessage(LocaleLoader.getString("Effects.Child.Overhaul", n, object));
        }
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return ImmutableList.of((Object)"?");
            }
        }
        return ImmutableList.of();
    }

    protected int calculateRank(float f, int n, int n2) {
        return Math.min((int)f, n) / n2;
    }

    protected String[] getAbilityDisplayValues(SkillActivationType skillActivationType, Player player, SubSkillType subSkillType) {
        return RandomChanceUtil.calculateAbilityDisplayValues(skillActivationType, player, subSkillType);
    }

    protected String[] calculateLengthDisplayValues(Player player, float f) {
        int n = this.skill.getAbility().getMaxLength();
        int n2 = AdvancedConfig.getInstance().getAbilityLength();
        int n3 = AdvancedConfig.getInstance().getAbilityLengthCap();
        int n4 = n3 <= 0 ? 2 + (int)(f / (float)n2) : 2 + (int)(Math.min((float)n3, f) / (float)n2);
        int n5 = PerksUtils.handleActivationPerks(player, n4, n);
        if (n != 0) {
            n4 = Math.min(n4, n);
        }
        return new String[]{String.valueOf(n4), String.valueOf(n5)};
    }

    protected String getStatMessage(SubSkillType subSkillType, String ... stringArray) {
        return this.getStatMessage(false, false, subSkillType, stringArray);
    }

    protected String getStatMessage(boolean bl, boolean bl2, SubSkillType subSkillType, String ... stringArray) {
        String string;
        String string2 = bl2 ? "Ability.Generic.Template.Custom" : "Ability.Generic.Template";
        String string3 = string = !bl ? subSkillType.getLocaleKeyStatDescription() : subSkillType.getLocaleKeyStatExtraDescription();
        if (bl2) {
            return LocaleLoader.getString(string2, LocaleLoader.getString(string, stringArray));
        }
        Object[] objectArray = NotificationManager.addItemToFirstPositionOfArray(LocaleLoader.getString(string), stringArray);
        return LocaleLoader.getString(string2, objectArray);
    }

    protected String getLimitBreakDescriptionParameter() {
        if (AdvancedConfig.getInstance().canApplyLimitBreakPVE()) {
            return "(PVP/PVE)";
        }
        return "(PVP)";
    }

    protected abstract void dataCalculations(Player var1, float var2);

    protected abstract void permissionsCheck(Player var1);

    protected abstract List<String> statsDisplay(Player var1, float var2, boolean var3, boolean var4);

    protected abstract List<TextComponent> getTextComponents(Player var1);

    protected boolean canUseSubskill(Player player, SubSkillType subSkillType) {
        return Permissions.isSubSkillEnabled((Permissible)player, subSkillType) && RankUtils.hasUnlockedSubskill(player, subSkillType);
    }
}

