/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class SalvageCommand
extends SkillCommand {
    private boolean canScrapCollector;
    private boolean canArcaneSalvage;

    public SalvageCommand() {
        super(PrimarySkillType.SALVAGE);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canScrapCollector = this.canUseSubskill(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR);
        this.canArcaneSalvage = this.canUseSubskill(player, SubSkillType.SALVAGE_ARCANE_SALVAGE);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SalvageManager salvageManager = UserManager.getPlayer(player).getSalvageManager();
        if (this.canScrapCollector) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.SALVAGE_SCRAP_COLLECTOR, String.valueOf(RankUtils.getRank(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR)), RankUtils.getHighestRankStr(SubSkillType.SALVAGE_SCRAP_COLLECTOR)));
        }
        if (this.canArcaneSalvage) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.SALVAGE_ARCANE_SALVAGE, String.valueOf(salvageManager.getArcaneSalvageRank()), String.valueOf(RankUtils.getHighestRank(SubSkillType.SALVAGE_ARCANE_SALVAGE))));
            if (Salvage.arcaneSalvageEnchantLoss) {
                arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Salvage.Arcane.ExtractFull"), this.percent.format(salvageManager.getExtractFullEnchantChance() / 100.0)));
            }
            if (Salvage.arcaneSalvageDowngrades) {
                arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Salvage.Arcane.ExtractPartial"), this.percent.format(salvageManager.getExtractPartialEnchantChance() / 100.0)));
            }
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.SALVAGE);
        return arrayList;
    }
}

