/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.ArcaneForging;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class RepairCommand
extends SkillCommand {
    private String repairMasteryBonus;
    private String superRepairChance;
    private String superRepairChanceLucky;
    private boolean canSuperRepair;
    private boolean canMasterRepair;
    private boolean canArcaneForge;
    private boolean canRepairStone;
    private boolean canRepairIron;
    private boolean canRepairGold;
    private boolean canRepairDiamond;
    private boolean canRepairString;
    private boolean canRepairLeather;
    private boolean canRepairWood;
    private boolean arcaneBypass;
    private int diamondLevel;
    private int goldLevel;
    private int ironLevel;
    private int stoneLevel;

    public RepairCommand() {
        super(PrimarySkillType.REPAIR);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        Repairable repairable = mcMMO.getRepairableManager().getRepairable(Material.DIAMOND_PICKAXE);
        Repairable repairable2 = mcMMO.getRepairableManager().getRepairable(Material.GOLDEN_PICKAXE);
        Repairable repairable3 = mcMMO.getRepairableManager().getRepairable(Material.IRON_PICKAXE);
        Repairable repairable4 = mcMMO.getRepairableManager().getRepairable(Material.STONE_PICKAXE);
        this.diamondLevel = repairable == null ? 0 : repairable.getMinimumLevel();
        this.goldLevel = repairable2 == null ? 0 : repairable2.getMinimumLevel();
        this.ironLevel = repairable3 == null ? 0 : repairable3.getMinimumLevel();
        int n = this.stoneLevel = repairable4 == null ? 0 : repairable4.getMinimumLevel();
        if (this.canMasterRepair) {
            this.repairMasteryBonus = this.percent.format(Math.min(Repair.repairMasteryMaxBonus / (double)Repair.repairMasteryMaxBonusLevel * (double)f, Repair.repairMasteryMaxBonus) / 100.0);
        }
        if (this.canSuperRepair) {
            String[] stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.REPAIR_SUPER_REPAIR);
            this.superRepairChance = stringArray[0];
            this.superRepairChanceLucky = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSuperRepair = this.canUseSubskill(player, SubSkillType.REPAIR_SUPER_REPAIR);
        this.canMasterRepair = this.canUseSubskill(player, SubSkillType.REPAIR_REPAIR_MASTERY);
        this.canArcaneForge = this.canUseSubskill(player, SubSkillType.REPAIR_ARCANE_FORGING);
        this.canRepairDiamond = Permissions.repairMaterialType((Permissible)player, MaterialType.DIAMOND);
        this.canRepairGold = Permissions.repairMaterialType((Permissible)player, MaterialType.GOLD);
        this.canRepairIron = Permissions.repairMaterialType((Permissible)player, MaterialType.IRON);
        this.canRepairStone = Permissions.repairMaterialType((Permissible)player, MaterialType.STONE);
        this.canRepairString = Permissions.repairMaterialType((Permissible)player, MaterialType.STRING);
        this.canRepairLeather = Permissions.repairMaterialType((Permissible)player, MaterialType.LEATHER);
        this.canRepairWood = Permissions.repairMaterialType((Permissible)player, MaterialType.WOOD);
        this.arcaneBypass = Permissions.arcaneBypass((Permissible)player) || Permissions.hasRepairEnchantBypassPerk((Permissible)player);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canArcaneForge) {
            RepairManager repairManager = UserManager.getPlayer(player).getRepairManager();
            arrayList.add(this.getStatMessage(false, true, SubSkillType.REPAIR_ARCANE_FORGING, String.valueOf(RankUtils.getRank(player, SubSkillType.REPAIR_ARCANE_FORGING)), RankUtils.getHighestRankStr(SubSkillType.REPAIR_ARCANE_FORGING)));
            if (ArcaneForging.arcaneForgingEnchantLoss || ArcaneForging.arcaneForgingDowngrades) {
                arrayList.add(this.getStatMessage(true, true, SubSkillType.REPAIR_ARCANE_FORGING, String.valueOf(this.arcaneBypass ? 100.0 : repairManager.getKeepEnchantChance()), String.valueOf(this.arcaneBypass ? 0.0 : repairManager.getDowngradeEnchantChance())));
            }
        }
        if (this.canMasterRepair) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.REPAIR_REPAIR_MASTERY, this.repairMasteryBonus));
        }
        if (this.canSuperRepair) {
            arrayList.add(this.getStatMessage(SubSkillType.REPAIR_SUPER_REPAIR, this.superRepairChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.superRepairChanceLucky) : ""));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.REPAIR);
        return arrayList;
    }
}

