/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class MmoInfoCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player) {
            if (stringArray.length < 1) {
                return false;
            }
            Player player = (Player)commandSender;
            if (Permissions.mmoinfo((Permissible)player)) {
                if (stringArray == null || stringArray[0] == null) {
                    return false;
                }
                if (stringArray[0].equalsIgnoreCase("???")) {
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Header"));
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.SubSkillHeader", "???"));
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.DetailsHeader"));
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Mystery"));
                    return true;
                }
                if (InteractionManager.getAbstractByName(stringArray[0]) != null || PrimarySkillType.SUBSKILL_NAMES.contains(stringArray[0])) {
                    this.displayInfo(player, stringArray[0]);
                    return true;
                }
                player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.NoMatch"));
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], PrimarySkillType.SUBSKILL_NAMES, new ArrayList(PrimarySkillType.SUBSKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    private void displayInfo(Player player, String string) {
        AbstractSubSkill abstractSubSkill = InteractionManager.getAbstractByName(string);
        if (abstractSubSkill != null) {
            abstractSubSkill.printInfo(player);
        } else {
            player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Header"));
            player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.SubSkillHeader", string));
            player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.DetailsHeader"));
            player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.OldSkill"));
        }
        for (SubSkillType subSkillType : SubSkillType.values()) {
            if (!subSkillType.getNiceNameNoSpaces(subSkillType).equalsIgnoreCase(string)) continue;
            string = subSkillType.getWikiName(subSkillType.toString());
        }
        TextComponentFactory.sendPlayerSubSkillWikiLink(player, string);
    }
}

