/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class MiningCommand
extends SkillCommand {
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private String superBreakerLength;
    private String superBreakerLengthEndurance;
    private int blastMiningRank;
    private int bonusTNTDrops;
    private double blastRadiusIncrease;
    private String oreBonus;
    private String debrisReduction;
    private String blastDamageDecrease;
    private boolean canSuperBreaker;
    private boolean canDoubleDrop;
    private boolean canBlast;
    private boolean canBiggerBombs;
    private boolean canDemoExpert;

    public MiningCommand() {
        super(PrimarySkillType.MINING);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        String[] stringArray;
        if (this.canBlast || this.canDemoExpert || this.canBiggerBombs) {
            stringArray = UserManager.getPlayer(player).getMiningManager();
            this.blastMiningRank = stringArray.getBlastMiningTier();
            this.bonusTNTDrops = stringArray.getDropMultiplier();
            this.oreBonus = this.percent.format(stringArray.getOreBonus() / 30.0);
            this.debrisReduction = this.percent.format(stringArray.getDebrisReduction() / 30.0);
            this.blastDamageDecrease = this.percent.format(stringArray.getBlastDamageModifier() / 100.0);
            this.blastRadiusIncrease = stringArray.getBlastRadiusModifier();
        }
        if (this.canDoubleDrop) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.MINING_DOUBLE_DROPS);
            this.doubleDropChance = stringArray[0];
            this.doubleDropChanceLucky = stringArray[1];
        }
        if (this.canSuperBreaker) {
            stringArray = this.calculateLengthDisplayValues(player, f);
            this.superBreakerLength = stringArray[0];
            this.superBreakerLengthEndurance = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBiggerBombs = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_BIGGER_BOMBS) && Permissions.biggerBombs((Permissible)player);
        this.canBlast = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_BLAST_MINING) && Permissions.remoteDetonation((Permissible)player);
        this.canDemoExpert = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_DEMOLITIONS_EXPERTISE) && Permissions.demolitionsExpertise((Permissible)player);
        this.canDoubleDrop = this.canUseSubskill(player, SubSkillType.MINING_DOUBLE_DROPS);
        this.canSuperBreaker = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_SUPER_BREAKER) && Permissions.superBreaker((Permissible)player);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canBiggerBombs) {
            arrayList.add(this.getStatMessage(true, true, SubSkillType.MINING_BLAST_MINING, String.valueOf(this.blastRadiusIncrease)));
        }
        if (this.canBlast) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.MINING_BLAST_MINING, String.valueOf(this.blastMiningRank), String.valueOf(RankUtils.getHighestRank(SubSkillType.MINING_BLAST_MINING)), LocaleLoader.getString("Mining.Blast.Effect", this.oreBonus, this.debrisReduction, this.bonusTNTDrops)));
        }
        if (this.canDemoExpert) {
            arrayList.add(this.getStatMessage(SubSkillType.MINING_DEMOLITIONS_EXPERTISE, this.blastDamageDecrease));
        }
        if (this.canDoubleDrop) {
            arrayList.add(this.getStatMessage(SubSkillType.MINING_DOUBLE_DROPS, this.doubleDropChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canSuperBreaker) {
            arrayList.add(this.getStatMessage(SubSkillType.MINING_SUPER_BREAKER, this.superBreakerLength) + (bl ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.superBreakerLengthEndurance) : ""));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.MINING);
        return arrayList;
    }
}

