/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class HerbalismCommand
extends SkillCommand {
    private String greenTerraLength;
    private String greenTerraLengthEndurance;
    private String greenThumbChance;
    private String greenThumbChanceLucky;
    private int greenThumbStage;
    private int farmersDietRank;
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private String hylianLuckChance;
    private String hylianLuckChanceLucky;
    private String shroomThumbChance;
    private String shroomThumbChanceLucky;
    private boolean hasHylianLuck;
    private boolean canGreenTerra;
    private boolean canGreenThumbPlants;
    private boolean canGreenThumbBlocks;
    private boolean canFarmersDiet;
    private boolean canDoubleDrop;
    private boolean canShroomThumb;

    public HerbalismCommand() {
        super(PrimarySkillType.HERBALISM);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        String[] stringArray;
        if (this.canDoubleDrop) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.HERBALISM_DOUBLE_DROPS);
            this.doubleDropChance = stringArray[0];
            this.doubleDropChanceLucky = stringArray[1];
        }
        if (this.canFarmersDiet) {
            this.farmersDietRank = RankUtils.getRank(player, SubSkillType.HERBALISM_FARMERS_DIET);
        }
        if (this.canGreenTerra) {
            stringArray = this.calculateLengthDisplayValues(player, f);
            this.greenTerraLength = stringArray[0];
            this.greenTerraLengthEndurance = stringArray[1];
        }
        if (this.canGreenThumbBlocks || this.canGreenThumbPlants) {
            this.greenThumbStage = RankUtils.getRank(player, SubSkillType.HERBALISM_GREEN_THUMB);
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.HERBALISM_GREEN_THUMB);
            this.greenThumbChance = stringArray[0];
            this.greenThumbChanceLucky = stringArray[1];
        }
        if (this.hasHylianLuck) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.HERBALISM_HYLIAN_LUCK);
            this.hylianLuckChance = stringArray[0];
            this.hylianLuckChanceLucky = stringArray[1];
        }
        if (this.canShroomThumb) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.HERBALISM_SHROOM_THUMB);
            this.shroomThumbChance = stringArray[0];
            this.shroomThumbChanceLucky = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.hasHylianLuck = this.canUseSubskill(player, SubSkillType.HERBALISM_HYLIAN_LUCK);
        this.canGreenTerra = Permissions.greenTerra((Permissible)player);
        this.canGreenThumbPlants = RankUtils.hasUnlockedSubskill(player, SubSkillType.HERBALISM_GREEN_THUMB) && (Permissions.greenThumbPlant((Permissible)player, Material.WHEAT) || Permissions.greenThumbPlant((Permissible)player, Material.CARROT) || Permissions.greenThumbPlant((Permissible)player, Material.POTATO) || Permissions.greenThumbPlant((Permissible)player, Material.BEETROOT) || Permissions.greenThumbPlant((Permissible)player, Material.NETHER_WART) || Permissions.greenThumbPlant((Permissible)player, Material.COCOA));
        this.canGreenThumbBlocks = RankUtils.hasUnlockedSubskill(player, SubSkillType.HERBALISM_GREEN_THUMB) && (Permissions.greenThumbBlock((Permissible)player, Material.DIRT) || Permissions.greenThumbBlock((Permissible)player, Material.COBBLESTONE) || Permissions.greenThumbBlock((Permissible)player, Material.COBBLESTONE_WALL) || Permissions.greenThumbBlock((Permissible)player, Material.STONE_BRICKS));
        this.canFarmersDiet = this.canUseSubskill(player, SubSkillType.HERBALISM_FARMERS_DIET);
        this.canDoubleDrop = this.canUseSubskill(player, SubSkillType.HERBALISM_DOUBLE_DROPS) && !this.skill.getDoubleDropsDisabled();
        this.canShroomThumb = this.canUseSubskill(player, SubSkillType.HERBALISM_SHROOM_THUMB);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canDoubleDrop) {
            arrayList.add(this.getStatMessage(SubSkillType.HERBALISM_DOUBLE_DROPS, this.doubleDropChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canFarmersDiet) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.HERBALISM_FARMERS_DIET, String.valueOf(this.farmersDietRank)));
        }
        if (this.canGreenTerra) {
            arrayList.add(this.getStatMessage(SubSkillType.HERBALISM_GREEN_TERRA, this.greenTerraLength) + (bl ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.greenTerraLengthEndurance) : ""));
        }
        if (this.canGreenThumbBlocks || this.canGreenThumbPlants) {
            arrayList.add(this.getStatMessage(SubSkillType.HERBALISM_GREEN_THUMB, this.greenThumbChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.greenThumbChanceLucky) : ""));
        }
        if (this.canGreenThumbPlants) {
            arrayList.add(this.getStatMessage(true, true, SubSkillType.HERBALISM_GREEN_THUMB, String.valueOf(this.greenThumbStage)));
        }
        if (this.hasHylianLuck) {
            arrayList.add(this.getStatMessage(SubSkillType.HERBALISM_HYLIAN_LUCK, this.hylianLuckChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.hylianLuckChanceLucky) : ""));
        }
        if (this.canShroomThumb) {
            arrayList.add(this.getStatMessage(SubSkillType.HERBALISM_SHROOM_THUMB, this.shroomThumbChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.shroomThumbChanceLucky) : ""));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.HERBALISM);
        return arrayList;
    }
}

