/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.fishing.Fishing;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class FishingCommand
extends SkillCommand {
    private int lootTier;
    private String shakeChance;
    private String shakeChanceLucky;
    private int fishermansDietRank;
    private String biteChance;
    private String trapTreasure;
    private String commonTreasure;
    private String uncommonTreasure;
    private String rareTreasure;
    private String epicTreasure;
    private String legendaryTreasure;
    private String recordTreasure;
    private String magicChance;
    private boolean canTreasureHunt;
    private boolean canMagicHunt;
    private boolean canShake;
    private boolean canFishermansDiet;
    private boolean canMasterAngler;
    private boolean canIceFish;

    public FishingCommand() {
        super(PrimarySkillType.FISHING);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        double d;
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        if (this.canTreasureHunt) {
            this.lootTier = fishingManager.getLootTier();
            this.commonTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.COMMON) / 100.0);
            this.uncommonTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.UNCOMMON) / 100.0);
            this.rareTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.RARE) / 100.0);
            this.epicTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.EPIC) / 100.0);
            this.legendaryTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.LEGENDARY) / 100.0);
            this.recordTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.RECORD) / 100.0);
            d = 0.0;
            for (Rarity rarity : Rarity.values()) {
                if (rarity == Rarity.RECORD) continue;
                d += TreasureConfig.getInstance().getEnchantmentDropRate(this.lootTier, rarity);
            }
            this.magicChance = d >= 1.0 ? this.percent.format(d / 100.0) : this.percent.format(0L);
        }
        if (this.canShake) {
            String[] stringArray = RandomChanceUtil.calculateAbilityDisplayValuesStatic(player, PrimarySkillType.FISHING, fishingManager.getShakeChance());
            this.shakeChance = stringArray[0];
            this.shakeChanceLucky = stringArray[1];
        }
        if (this.canFishermansDiet) {
            this.fishermansDietRank = RankUtils.getRank(player, SubSkillType.FISHING_FISHERMANS_DIET);
        }
        if (this.canMasterAngler) {
            d = 1.0 / (double)(player.getWorld().hasStorm() ? 300 : 500);
            Rarity[] rarityArray = fishingManager.getHookLocation();
            if (rarityArray == null) {
                rarityArray = player.getLocation();
            }
            if (Fishing.masterAnglerBiomes.contains(rarityArray.getBlock().getBiome())) {
                d *= AdvancedConfig.getInstance().getMasterAnglerBiomeModifier();
            }
            if (player.isInsideVehicle() && player.getVehicle().getType() == EntityType.BOAT) {
                d *= AdvancedConfig.getInstance().getMasterAnglerBoatModifier();
            }
            double d2 = Permissions.lucky((Permissible)player, PrimarySkillType.FISHING) ? 1.333 : 1.0;
            this.biteChance = this.percent.format(d * 100.0 * d2);
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canTreasureHunt = this.canUseSubskill(player, SubSkillType.FISHING_TREASURE_HUNTER);
        this.canMagicHunt = this.canUseSubskill(player, SubSkillType.FISHING_MAGIC_HUNTER) && this.canUseSubskill(player, SubSkillType.FISHING_TREASURE_HUNTER);
        this.canShake = this.canUseSubskill(player, SubSkillType.FISHING_SHAKE);
        this.canFishermansDiet = this.canUseSubskill(player, SubSkillType.FISHING_FISHERMANS_DIET);
        this.canMasterAngler = this.canUseSubskill(player, SubSkillType.FISHING_MASTER_ANGLER);
        this.canIceFish = this.canUseSubskill(player, SubSkillType.FISHING_ICE_FISHING);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canFishermansDiet) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.FISHING_FISHERMANS_DIET, String.valueOf(this.fishermansDietRank)));
        }
        if (this.canIceFish) {
            arrayList.add(this.getStatMessage(SubSkillType.FISHING_ICE_FISHING, SubSkillType.FISHING_ICE_FISHING.getLocaleStatDescription()));
        }
        if (this.canMagicHunt) {
            arrayList.add(this.getStatMessage(SubSkillType.FISHING_MAGIC_HUNTER, this.magicChance));
        }
        if (this.canMasterAngler) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.FISHING_MASTER_ANGLER, this.biteChance));
        }
        if (this.canShake) {
            arrayList.add(this.getStatMessage(SubSkillType.FISHING_SHAKE, this.shakeChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.shakeChanceLucky) : ""));
        }
        if (this.canTreasureHunt) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.FISHING_TREASURE_HUNTER, String.valueOf(this.lootTier), String.valueOf(RankUtils.getHighestRank(SubSkillType.FISHING_TREASURE_HUNTER))));
            arrayList.add(this.getStatMessage(true, true, SubSkillType.FISHING_TREASURE_HUNTER, String.valueOf(this.commonTreasure), String.valueOf(this.uncommonTreasure), String.valueOf(this.rareTreasure), String.valueOf(this.epicTreasure), String.valueOf(this.legendaryTreasure), String.valueOf(this.recordTreasure)));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.FISHING);
        return arrayList;
    }
}

