/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class ExcavationCommand
extends SkillCommand {
    private String gigaDrillBreakerLength;
    private String gigaDrillBreakerLengthEndurance;
    private boolean canGigaDrill;
    private boolean canTreasureHunt;

    public ExcavationCommand() {
        super(PrimarySkillType.EXCAVATION);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        if (this.canGigaDrill) {
            String[] stringArray = this.calculateLengthDisplayValues(player, f);
            this.gigaDrillBreakerLength = stringArray[0];
            this.gigaDrillBreakerLengthEndurance = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canGigaDrill = Permissions.gigaDrillBreaker((Permissible)player) && RankUtils.hasUnlockedSubskill(player, SubSkillType.EXCAVATION_GIGA_DRILL_BREAKER);
        this.canTreasureHunt = this.canUseSubskill(player, SubSkillType.EXCAVATION_ARCHAEOLOGY);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ExcavationManager excavationManager = UserManager.getPlayer(player).getExcavationManager();
        if (this.canGigaDrill) {
            arrayList.add(this.getStatMessage(SubSkillType.EXCAVATION_GIGA_DRILL_BREAKER, this.gigaDrillBreakerLength) + (bl ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.gigaDrillBreakerLengthEndurance) : ""));
        }
        if (this.canUseSubskill(player, SubSkillType.EXCAVATION_ARCHAEOLOGY)) {
            arrayList.add(this.getStatMessage(false, false, SubSkillType.EXCAVATION_ARCHAEOLOGY, this.percent.format(excavationManager.getArchaelogyExperienceOrbChance() / 100.0)));
            arrayList.add(this.getStatMessage(true, false, SubSkillType.EXCAVATION_ARCHAEOLOGY, String.valueOf(excavationManager.getExperienceOrbsReward())));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.EXCAVATION);
        return arrayList;
    }
}

