/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.axes.Axes;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AxesCommand
extends SkillCommand {
    private String critChance;
    private String critChanceLucky;
    private double axeMasteryDamage;
    private double impactDamage;
    private String skullSplitterLength;
    private String skullSplitterLengthEndurance;
    private boolean canSkullSplitter;
    private boolean canCritical;
    private boolean canAxeMastery;
    private boolean canImpact;
    private boolean canGreaterImpact;

    public AxesCommand() {
        super(PrimarySkillType.AXES);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        String[] stringArray;
        if (this.canImpact) {
            this.impactDamage = UserManager.getPlayer(player).getAxesManager().getImpactDurabilityDamage();
        }
        if (this.canAxeMastery) {
            this.axeMasteryDamage = Axes.getAxeMasteryBonusDamage(player);
        }
        if (this.canCritical) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.AXES_CRITICAL_STRIKES);
            this.critChance = stringArray[0];
            this.critChanceLucky = stringArray[1];
        }
        if (this.canSkullSplitter) {
            stringArray = this.calculateLengthDisplayValues(player, f);
            this.skullSplitterLength = stringArray[0];
            this.skullSplitterLengthEndurance = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSkullSplitter = Permissions.skullSplitter((Permissible)player) && RankUtils.hasUnlockedSubskill(player, SubSkillType.AXES_SKULL_SPLITTER);
        this.canCritical = this.canUseSubskill(player, SubSkillType.AXES_CRITICAL_STRIKES);
        this.canAxeMastery = this.canUseSubskill(player, SubSkillType.AXES_AXE_MASTERY);
        this.canImpact = this.canUseSubskill(player, SubSkillType.AXES_ARMOR_IMPACT);
        this.canGreaterImpact = this.canUseSubskill(player, SubSkillType.AXES_GREATER_IMPACT);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canImpact) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.2"), LocaleLoader.getString("Axes.Ability.Bonus.3", this.impactDamage)));
        }
        if (this.canAxeMastery) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.0"), LocaleLoader.getString("Axes.Ability.Bonus.1", this.axeMasteryDamage)));
        }
        if (this.canCritical) {
            arrayList.add(this.getStatMessage(SubSkillType.AXES_CRITICAL_STRIKES, this.critChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.critChanceLucky) : ""));
        }
        if (this.canGreaterImpact) {
            arrayList.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.4"), LocaleLoader.getString("Axes.Ability.Bonus.5", Axes.greaterImpactBonusDamage)));
        }
        if (this.canSkullSplitter) {
            arrayList.add(this.getStatMessage(SubSkillType.AXES_SKULL_SPLITTER, this.skullSplitterLength) + (bl ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.skullSplitterLengthEndurance) : ""));
        }
        if (this.canUseSubskill(player, SubSkillType.AXES_AXES_LIMIT_BREAK)) {
            arrayList.add(this.getStatMessage(SubSkillType.AXES_AXES_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.AXES_AXES_LIMIT_BREAK, 1000))));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.AXES);
        return arrayList;
    }
}

