/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ArcheryCommand
extends SkillCommand {
    private String skillShotBonus;
    private String dazeChance;
    private String dazeChanceLucky;
    private String retrieveChance;
    private String retrieveChanceLucky;
    private boolean canSkillShot;
    private boolean canDaze;
    private boolean canRetrieve;

    public ArcheryCommand() {
        super(PrimarySkillType.ARCHERY);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        String[] stringArray;
        if (this.canRetrieve) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.ARCHERY_ARROW_RETRIEVAL);
            this.retrieveChance = stringArray[0];
            this.retrieveChanceLucky = stringArray[1];
        }
        if (this.canDaze) {
            stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.ARCHERY_DAZE);
            this.dazeChance = stringArray[0];
            this.dazeChanceLucky = stringArray[1];
        }
        if (this.canSkillShot) {
            this.skillShotBonus = this.percent.format(Archery.getDamageBonusPercent(player));
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSkillShot = this.canUseSubskill(player, SubSkillType.ARCHERY_SKILL_SHOT);
        this.canDaze = this.canUseSubskill(player, SubSkillType.ARCHERY_DAZE);
        this.canRetrieve = this.canUseSubskill(player, SubSkillType.ARCHERY_ARROW_RETRIEVAL);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canRetrieve) {
            arrayList.add(this.getStatMessage(SubSkillType.ARCHERY_ARROW_RETRIEVAL, this.retrieveChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.retrieveChanceLucky) : ""));
        }
        if (this.canDaze) {
            arrayList.add(this.getStatMessage(SubSkillType.ARCHERY_DAZE, this.dazeChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.dazeChanceLucky) : ""));
        }
        if (this.canSkillShot) {
            arrayList.add(this.getStatMessage(SubSkillType.ARCHERY_SKILL_SHOT, this.skillShotBonus));
        }
        if (this.canUseSubskill(player, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK)) {
            arrayList.add(this.getStatMessage(SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK, 1000))));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.ARCHERY);
        return arrayList;
    }
}

