/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AlchemyCommand
extends SkillCommand {
    private String brewSpeed;
    private String brewSpeedLucky;
    private int tier;
    private int ingredientCount;
    private String ingredientList;
    private boolean canCatalysis;
    private boolean canConcoctions;

    public AlchemyCommand() {
        super(PrimarySkillType.ALCHEMY);
    }

    protected String[] calculateAbilityDisplayValues(Player player) {
        if (UserManager.getPlayer(player) == null) {
            player.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return new String[]{"DATA NOT LOADED", "DATA NOT LOADED"};
        }
        AlchemyManager alchemyManager = UserManager.getPlayer(player).getAlchemyManager();
        String[] stringArray = new String[2];
        boolean bl = Permissions.lucky((Permissible)player, PrimarySkillType.ALCHEMY);
        stringArray[0] = this.decimal.format(alchemyManager.calculateBrewSpeed(false)) + "x";
        stringArray[1] = bl ? this.decimal.format(alchemyManager.calculateBrewSpeed(true)) + "x" : null;
        return stringArray;
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        Object object;
        if (this.canCatalysis) {
            object = this.calculateAbilityDisplayValues(player);
            this.brewSpeed = object[0];
            this.brewSpeedLucky = object[1];
        }
        if (this.canConcoctions) {
            object = UserManager.getPlayer(player).getAlchemyManager();
            this.tier = ((AlchemyManager)object).getTier();
            this.ingredientCount = ((AlchemyManager)object).getIngredients().size();
            this.ingredientList = ((AlchemyManager)object).getIngredientList();
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canCatalysis = this.canUseSubskill(player, SubSkillType.ALCHEMY_CATALYSIS);
        this.canConcoctions = this.canUseSubskill(player, SubSkillType.ALCHEMY_CONCOCTIONS);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canCatalysis) {
            arrayList.add(this.getStatMessage(SubSkillType.ALCHEMY_CATALYSIS, this.brewSpeed) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.brewSpeedLucky) : ""));
        }
        if (this.canConcoctions) {
            arrayList.add(this.getStatMessage(false, true, SubSkillType.ALCHEMY_CONCOCTIONS, String.valueOf(this.tier), String.valueOf(RankUtils.getHighestRank(SubSkillType.ALCHEMY_CONCOCTIONS))));
            arrayList.add(this.getStatMessage(true, true, SubSkillType.ALCHEMY_CONCOCTIONS, String.valueOf(this.ingredientCount), this.ingredientList));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.ALCHEMY);
        return arrayList;
    }
}

