/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.random.RandomChanceSkill;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class AcrobaticsCommand
extends SkillCommand {
    private String dodgeChance;
    private String dodgeChanceLucky;
    private boolean canDodge;
    private boolean canRoll;

    public AcrobaticsCommand() {
        super(PrimarySkillType.ACROBATICS);
    }

    @Override
    protected void dataCalculations(Player player, float f) {
        if (this.canDodge) {
            String[] stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.ACROBATICS_DODGE);
            this.dodgeChance = stringArray[0];
            this.dodgeChanceLucky = stringArray[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canDodge = this.canUseSubskill(player, SubSkillType.ACROBATICS_DODGE);
        this.canRoll = this.canUseSubskill(player, SubSkillType.ACROBATICS_ROLL);
    }

    @Override
    protected List<String> statsDisplay(Player player, float f, boolean bl, boolean bl2) {
        AbstractSubSkill abstractSubSkill;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.canDodge) {
            arrayList.add(this.getStatMessage(SubSkillType.ACROBATICS_DODGE, this.dodgeChance) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", this.dodgeChanceLucky) : ""));
        }
        if (this.canRoll && (abstractSubSkill = InteractionManager.getAbstractByName("Roll")) != null) {
            RandomChanceSkill randomChanceSkill = new RandomChanceSkill(player, SubSkillType.ACROBATICS_ROLL);
            RandomChanceSkill randomChanceSkill2 = new RandomChanceSkill(player, SubSkillType.ACROBATICS_ROLL);
            randomChanceSkill2.setSkillLevel(randomChanceSkill2.getSkillLevel() * 2);
            double d = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceSkill);
            double d2 = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceSkill2);
            String[] stringArray = this.getAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.ACROBATICS_ROLL);
            double d3 = d * 1.333;
            double d4 = d2 * 1.333;
            arrayList.add(this.getStatMessage(SubSkillType.ACROBATICS_ROLL, stringArray[0]) + (bl2 ? LocaleLoader.getString("Perks.Lucky.Bonus", stringArray[1]) : ""));
        }
        return arrayList;
    }

    @Override
    protected List<TextComponent> getTextComponents(Player player) {
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponentFactory.getSubSkillTextComponents(player, arrayList, PrimarySkillType.ACROBATICS);
        return arrayList;
    }
}

