/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.MctopCommandAsyncTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class MctopCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        PrimarySkillType primarySkillType = null;
        switch (stringArray.length) {
            case 0: {
                this.display(1, primarySkillType, commandSender, command);
                return true;
            }
            case 1: {
                if (StringUtils.isInt(stringArray[0])) {
                    this.display(Math.abs(Integer.parseInt(stringArray[0])), primarySkillType, commandSender, command);
                    return true;
                }
                primarySkillType = this.extractSkill(commandSender, stringArray[0]);
                if (primarySkillType == null) {
                    return true;
                }
                this.display(1, primarySkillType, commandSender, command);
                return true;
            }
            case 2: {
                if (CommandUtils.isInvalidInteger(commandSender, stringArray[1])) {
                    return true;
                }
                primarySkillType = this.extractSkill(commandSender, stringArray[0]);
                if (primarySkillType == null) {
                    return true;
                }
                this.display(Math.abs(Integer.parseInt(stringArray[1])), primarySkillType, commandSender, command);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], PrimarySkillType.SKILL_NAMES, new ArrayList(PrimarySkillType.SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    private void display(int n, PrimarySkillType primarySkillType, CommandSender commandSender, Command command) {
        if (primarySkillType != null && !Permissions.mctop((Permissible)commandSender, primarySkillType)) {
            commandSender.sendMessage(command.getPermissionMessage());
            return;
        }
        if (commandSender instanceof Player) {
            if (!CommandUtils.hasPlayerDataKey(commandSender)) {
                return;
            }
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(commandSender.getName());
            long l = Math.max(Config.getInstance().getDatabasePlayerCooldown(), 1750L);
            if (mcMMOPlayer.getDatabaseATS() + l > System.currentTimeMillis()) {
                double d = (mcMMOPlayer.getDatabaseATS() + l - System.currentTimeMillis()) / 1000L;
                if (d < 1.0) {
                    d = 1.0;
                }
                commandSender.sendMessage(LocaleLoader.formatString(LocaleLoader.getString("Commands.Database.Cooldown"), d));
                return;
            }
            if (((Player)commandSender).hasMetadata("mcMMO: Processing Database Command")) {
                commandSender.sendMessage(LocaleLoader.getString("Commands.Database.Processing"));
                return;
            }
            ((Player)commandSender).setMetadata("mcMMO: Processing Database Command", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, null));
            mcMMOPlayer.actualizeDatabaseATS();
        }
        this.display(n, primarySkillType, commandSender);
    }

    private void display(int n, PrimarySkillType primarySkillType, CommandSender commandSender) {
        boolean bl = commandSender instanceof Player && Config.getInstance().getTopUseBoard();
        boolean bl2 = !bl || Config.getInstance().getTopUseChat();
        new MctopCommandAsyncTask(n, primarySkillType, commandSender, bl, bl2).runTaskAsynchronously((Plugin)mcMMO.p);
    }

    private PrimarySkillType extractSkill(CommandSender commandSender, String string) {
        if (CommandUtils.isInvalidSkill(commandSender, string)) {
            return null;
        }
        PrimarySkillType primarySkillType = PrimarySkillType.getSkill(string);
        if (CommandUtils.isChildSkill(commandSender, primarySkillType)) {
            return null;
        }
        return primarySkillType;
    }
}

