/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McrankCommandAsyncTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class McrankCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                if (CommandUtils.noConsoleUsage(commandSender)) {
                    return true;
                }
                if (!Permissions.mcrank((Permissible)commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(commandSender)) {
                    return true;
                }
                this.display(commandSender, commandSender.getName());
                return true;
            }
            case 1: {
                if (!Permissions.mcrankOthers((Permissible)commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(commandSender)) {
                    return true;
                }
                String string2 = CommandUtils.getMatchedPlayerName(stringArray[0]);
                McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(string2);
                if (mcMMOPlayer != null) {
                    Player player = mcMMOPlayer.getPlayer();
                    string2 = player.getName();
                    if (CommandUtils.tooFar(commandSender, player, Permissions.mcrankFar((Permissible)commandSender))) {
                        return true;
                    }
                }
                this.display(commandSender, string2);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                List<String> list = CommandUtils.getOnlinePlayerNames(commandSender);
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], list, new ArrayList(list.size()));
            }
        }
        return ImmutableList.of();
    }

    private void display(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(commandSender.getName());
            if (mcMMOPlayer == null) {
                commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                return;
            }
            long l = Math.min(Config.getInstance().getDatabasePlayerCooldown(), 1750L);
            if (mcMMOPlayer.getDatabaseATS() + l > System.currentTimeMillis()) {
                commandSender.sendMessage(LocaleLoader.getString("Commands.Database.CooldownMS", this.getCDSeconds(mcMMOPlayer, l)));
                return;
            }
            if (((Player)commandSender).hasMetadata("mcMMO: Processing Database Command")) {
                commandSender.sendMessage(LocaleLoader.getString("Commands.Database.Processing"));
                return;
            }
            ((Player)commandSender).setMetadata("mcMMO: Processing Database Command", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, null));
            mcMMOPlayer.actualizeDatabaseATS();
        }
        boolean bl = Config.getInstance().getScoreboardsEnabled() && commandSender instanceof Player && Config.getInstance().getRankUseBoard();
        boolean bl2 = !bl || Config.getInstance().getRankUseChat();
        new McrankCommandAsyncTask(string, commandSender, bl, bl2).runTaskAsynchronously((Plugin)mcMMO.p);
    }

    private long getCDSeconds(McMMOPlayer mcMMOPlayer, long l) {
        return mcMMOPlayer.getDatabaseATS() + l - System.currentTimeMillis();
    }
}

