/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class MccooldownCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (CommandUtils.noConsoleUsage(commandSender)) {
            return true;
        }
        if (!CommandUtils.hasPlayerDataKey(commandSender)) {
            return true;
        }
        switch (stringArray.length) {
            case 0: {
                Player player = (Player)commandSender;
                if (Config.getInstance().getScoreboardsEnabled() && Config.getInstance().getCooldownUseBoard()) {
                    ScoreboardManager.enablePlayerCooldownScoreboard(player);
                    if (!Config.getInstance().getCooldownUseChat()) {
                        return true;
                    }
                }
                if (UserManager.getPlayer(player) == null) {
                    player.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                    return true;
                }
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
                player.sendMessage(LocaleLoader.getString("Commands.Cooldowns.Header"));
                player.sendMessage(LocaleLoader.getString("mcMMO.NoSkillNote"));
                for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
                    if (!superAbilityType.getPermissions(player)) continue;
                    int n = mcMMOPlayer.calculateTimeRemaining(superAbilityType);
                    if (n <= 0) {
                        player.sendMessage(LocaleLoader.getString("Commands.Cooldowns.Row.Y", superAbilityType.getName()));
                        continue;
                    }
                    player.sendMessage(LocaleLoader.getString("Commands.Cooldowns.Row.N", superAbilityType.getName(), n));
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        return ImmutableList.of();
    }
}

