/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class InspectCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                String string2 = CommandUtils.getMatchedPlayerName(stringArray[0]);
                McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(string2);
                if (mcMMOPlayer == null) {
                    PlayerProfile playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(string2, false);
                    if (!CommandUtils.isLoaded(commandSender, playerProfile)) {
                        return true;
                    }
                    if (Config.getInstance().getScoreboardsEnabled() && commandSender instanceof Player && Config.getInstance().getInspectUseBoard()) {
                        ScoreboardManager.enablePlayerInspectScoreboard((Player)commandSender, playerProfile);
                        if (!Config.getInstance().getInspectUseChat()) {
                            return true;
                        }
                    }
                    commandSender.sendMessage(LocaleLoader.getString("Inspect.OfflineStats", string2));
                    commandSender.sendMessage(LocaleLoader.getString("Stats.Header.Gathering"));
                    for (PrimarySkillType primarySkillType : PrimarySkillType.GATHERING_SKILLS) {
                        commandSender.sendMessage(CommandUtils.displaySkill(playerProfile, primarySkillType));
                    }
                    commandSender.sendMessage(LocaleLoader.getString("Stats.Header.Combat"));
                    for (PrimarySkillType primarySkillType : PrimarySkillType.COMBAT_SKILLS) {
                        commandSender.sendMessage(CommandUtils.displaySkill(playerProfile, primarySkillType));
                    }
                    commandSender.sendMessage(LocaleLoader.getString("Stats.Header.Misc"));
                    for (PrimarySkillType primarySkillType : PrimarySkillType.MISC_SKILLS) {
                        commandSender.sendMessage(CommandUtils.displaySkill(playerProfile, primarySkillType));
                    }
                } else {
                    Player player = mcMMOPlayer.getPlayer();
                    if (CommandUtils.hidden(commandSender, player, Permissions.inspectHidden((Permissible)commandSender))) {
                        commandSender.sendMessage(LocaleLoader.getString("Inspect.Offline"));
                        return true;
                    }
                    if (CommandUtils.tooFar(commandSender, player, Permissions.inspectFar((Permissible)commandSender))) {
                        return true;
                    }
                    if (Config.getInstance().getScoreboardsEnabled() && commandSender instanceof Player && Config.getInstance().getInspectUseBoard()) {
                        ScoreboardManager.enablePlayerInspectScoreboard((Player)commandSender, mcMMOPlayer.getProfile());
                        if (!Config.getInstance().getInspectUseChat()) {
                            return true;
                        }
                    }
                    commandSender.sendMessage(LocaleLoader.getString("Inspect.Stats", player.getName()));
                    CommandUtils.printGatheringSkills(player, commandSender);
                    CommandUtils.printCombatSkills(player, commandSender);
                    CommandUtils.printMiscSkills(player, commandSender);
                    commandSender.sendMessage(LocaleLoader.getString("Commands.PowerLevel", mcMMOPlayer.getPowerLevel()));
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                List<String> list = CommandUtils.getOnlinePlayerNames(commandSender);
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], list, new ArrayList(list.size()));
            }
        }
        return ImmutableList.of();
    }
}

