/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party.teleport;

import com.gmail.nossr50.commands.party.teleport.PtpAcceptAnyCommand;
import com.gmail.nossr50.commands.party.teleport.PtpAcceptCommand;
import com.gmail.nossr50.commands.party.teleport.PtpToggleCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.party.PartyTeleportRecord;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.runnables.items.TeleportationWarmup;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class PtpCommand
implements TabExecutor {
    public static final List<String> TELEPORT_SUBCOMMANDS = ImmutableList.of((Object)"toggle", (Object)"accept", (Object)"acceptany", (Object)"acceptall");
    private CommandExecutor ptpToggleCommand = new PtpToggleCommand();
    private CommandExecutor ptpAcceptAnyCommand = new PtpAcceptAnyCommand();
    private CommandExecutor ptpAcceptCommand = new PtpAcceptCommand();

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (CommandUtils.noConsoleUsage(commandSender)) {
            return true;
        }
        Player player = (Player)commandSender;
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return true;
        }
        if (WorldBlacklist.isWorldBlacklisted(player.getWorld())) {
            return true;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return true;
        }
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (!mcMMOPlayer.inParty()) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
            return true;
        }
        Party party = mcMMOPlayer.getParty();
        if (party.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.TELEPORT)) {
            commandSender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.2"));
            return true;
        }
        switch (stringArray.length) {
            case 1: {
                int n;
                int n2;
                if (stringArray[0].equalsIgnoreCase("toggle")) {
                    return this.ptpToggleCommand.onCommand(commandSender, command, string, stringArray);
                }
                if (stringArray[0].equalsIgnoreCase("acceptany") || stringArray[0].equalsIgnoreCase("acceptall")) {
                    return this.ptpAcceptAnyCommand.onCommand(commandSender, command, string, stringArray);
                }
                long l = mcMMOPlayer.getRecentlyHurt();
                int n3 = Config.getInstance().getPTPCommandRecentlyHurtCooldown();
                if (n3 > 0 && (n2 = SkillUtils.calculateTimeLeft(l * 1000L, n3, player)) > 0) {
                    player.sendMessage(LocaleLoader.getString("Item.Injured.Wait", n2));
                    return true;
                }
                if (stringArray[0].equalsIgnoreCase("accept")) {
                    return this.ptpAcceptCommand.onCommand(commandSender, command, string, stringArray);
                }
                if (!Permissions.partyTeleportSend((Permissible)commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                n2 = Config.getInstance().getPTPCommandCooldown();
                long l2 = mcMMOPlayer.getPartyTeleportRecord().getLastUse();
                if (n2 > 0 && (n = SkillUtils.calculateTimeLeft(l2 * 1000L, n2, player)) > 0) {
                    player.sendMessage(LocaleLoader.getString("Item.Generic.Wait", n));
                    return true;
                }
                this.sendTeleportRequest(commandSender, player, CommandUtils.getMatchedPlayerName(stringArray[0]));
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                List list = (List)StringUtil.copyPartialMatches((String)stringArray[0], TELEPORT_SUBCOMMANDS, new ArrayList(TELEPORT_SUBCOMMANDS.size()));
                if (list.size() == 0) {
                    if (UserManager.getPlayer((Player)commandSender) == null) {
                        commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                        return ImmutableList.of();
                    }
                    Player player = (Player)commandSender;
                    McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
                    if (!mcMMOPlayer.inParty()) {
                        return ImmutableList.of();
                    }
                    List<String> list2 = mcMMOPlayer.getParty().getOnlinePlayerNames((CommandSender)player);
                    return (List)StringUtil.copyPartialMatches((String)stringArray[0], list2, new ArrayList(list2.size()));
                }
                return list;
            }
        }
        return ImmutableList.of();
    }

    private void sendTeleportRequest(CommandSender commandSender, Player player, String string) {
        if (!PtpCommand.canTeleport(commandSender, player, string)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(string);
        Player player2 = mcMMOPlayer.getPlayer();
        PartyTeleportRecord partyTeleportRecord = mcMMOPlayer.getPartyTeleportRecord();
        if (!partyTeleportRecord.isConfirmRequired()) {
            PtpCommand.handleTeleportWarmup(player, player2);
            return;
        }
        partyTeleportRecord.setRequestor(player);
        partyTeleportRecord.actualizeTimeout();
        player.sendMessage(LocaleLoader.getString("Commands.Invite.Success"));
        player2.sendMessage(LocaleLoader.getString("Commands.ptp.Request1", player.getName()));
        player2.sendMessage(LocaleLoader.getString("Commands.ptp.Request2", Config.getInstance().getPTPCommandTimeout()));
    }

    protected static boolean canTeleport(CommandSender commandSender, Player player, String string) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(string);
        if (!CommandUtils.checkPlayerExistence(commandSender, string, mcMMOPlayer)) {
            return false;
        }
        Player player2 = mcMMOPlayer.getPlayer();
        if (player.equals(player2)) {
            player.sendMessage(LocaleLoader.getString("Party.Teleport.Self"));
            return false;
        }
        if (!PartyManager.inSameParty(player, player2)) {
            player.sendMessage(LocaleLoader.getString("Party.NotInYourParty", string));
            return false;
        }
        if (!mcMMOPlayer.getPartyTeleportRecord().isEnabled()) {
            player.sendMessage(LocaleLoader.getString("Party.Teleport.Disabled", string));
            return false;
        }
        if (!player2.isValid()) {
            player.sendMessage(LocaleLoader.getString("Party.Teleport.Dead"));
            return false;
        }
        return true;
    }

    protected static void handleTeleportWarmup(Player player, Player player2) {
        if (UserManager.getPlayer(player2) == null) {
            player2.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            player.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        McMMOPlayer mcMMOPlayer2 = UserManager.getPlayer(player2);
        long l = Config.getInstance().getPTPCommandWarmup();
        mcMMOPlayer.actualizeTeleportCommenceLocation(player);
        if (l > 0L) {
            player.sendMessage(LocaleLoader.getString("Teleport.Commencing", l));
            new TeleportationWarmup(mcMMOPlayer, mcMMOPlayer2).runTaskLater((Plugin)mcMMO.p, 20L * l);
        } else {
            EventUtils.handlePartyTeleportEvent(player, player2);
        }
    }
}

