/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party.teleport;

import com.gmail.nossr50.commands.party.teleport.PtpCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.PartyTeleportRecord;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class PtpAcceptCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!Permissions.partyTeleportAccept((Permissible)commandSender)) {
            commandSender.sendMessage(command.getPermissionMessage());
            return true;
        }
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        Player player = (Player)commandSender;
        PartyTeleportRecord partyTeleportRecord = UserManager.getPlayer(player).getPartyTeleportRecord();
        if (!partyTeleportRecord.hasRequest()) {
            player.sendMessage(LocaleLoader.getString("Commands.ptp.NoRequests"));
            return true;
        }
        if (SkillUtils.cooldownExpired(partyTeleportRecord.getTimeout(), Config.getInstance().getPTPCommandTimeout())) {
            partyTeleportRecord.removeRequest();
            player.sendMessage(LocaleLoader.getString("Commands.ptp.RequestExpired"));
            return true;
        }
        Player player2 = partyTeleportRecord.getRequestor();
        partyTeleportRecord.removeRequest();
        if (!PtpCommand.canTeleport(commandSender, player, player2.getName())) {
            return true;
        }
        if (Config.getInstance().getPTPCommandWorldPermissions()) {
            World world = player2.getWorld();
            World world2 = player.getWorld();
            if (!Permissions.partyTeleportAllWorlds((Permissible)player2)) {
                if (!Permissions.partyTeleportWorld((Permissible)player2, world)) {
                    player2.sendMessage(LocaleLoader.getString("Commands.ptp.NoWorldPermissions", world.getName()));
                    return true;
                }
                if (world != world2 && !Permissions.partyTeleportWorld((Permissible)player2, world2)) {
                    player2.sendMessage(LocaleLoader.getString("Commands.ptp.NoWorldPermissions", world2.getName()));
                    return true;
                }
            }
        }
        PtpCommand.handleTeleportWarmup(player2, player);
        return true;
    }
}

