/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party.alliance;

import com.gmail.nossr50.commands.party.alliance.PartyAllianceAcceptCommand;
import com.gmail.nossr50.commands.party.alliance.PartyAllianceDisbandCommand;
import com.gmail.nossr50.commands.party.alliance.PartyAllianceInviteCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class PartyAllianceCommand
implements TabExecutor {
    private Player player;
    private Party playerParty;
    private Party targetParty;
    public static final List<String> ALLIANCE_SUBCOMMANDS = ImmutableList.of((Object)"invite", (Object)"accept", (Object)"disband");
    private CommandExecutor partyAllianceInviteCommand = new PartyAllianceInviteCommand();
    private CommandExecutor partyAllianceAcceptCommand = new PartyAllianceAcceptCommand();
    private CommandExecutor partyAllianceDisbandCommand = new PartyAllianceDisbandCommand();

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (CommandUtils.noConsoleUsage(commandSender)) {
            return true;
        }
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        this.player = (Player)commandSender;
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(this.player);
        this.playerParty = mcMMOPlayer.getParty();
        switch (stringArray.length) {
            case 1: {
                if (this.playerParty.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.ALLIANCE)) {
                    commandSender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.3"));
                    return true;
                }
                if (this.playerParty.getAlly() == null) {
                    this.printUsage();
                    return true;
                }
                this.targetParty = this.playerParty.getAlly();
                this.displayPartyHeader();
                this.displayMemberInfo(mcMMOPlayer);
                return true;
            }
            case 2: 
            case 3: {
                if (this.playerParty.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.ALLIANCE)) {
                    commandSender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.3"));
                    return true;
                }
                if (stringArray[1].equalsIgnoreCase("invite")) {
                    return this.partyAllianceInviteCommand.onCommand(commandSender, command, string, stringArray);
                }
                if (stringArray[1].equalsIgnoreCase("accept")) {
                    return this.partyAllianceAcceptCommand.onCommand(commandSender, command, string, stringArray);
                }
                if (stringArray[1].equalsIgnoreCase("disband")) {
                    return this.partyAllianceDisbandCommand.onCommand(commandSender, command, string, stringArray);
                }
                if (this.playerParty.getAlly() == null) {
                    this.printUsage();
                    return true;
                }
                this.targetParty = this.playerParty.getAlly();
                this.displayPartyHeader();
                this.displayMemberInfo(mcMMOPlayer);
                return true;
            }
        }
        return false;
    }

    private boolean printUsage() {
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Help.0"));
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Help.1"));
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                List list = (List)StringUtil.copyPartialMatches((String)stringArray[0], ALLIANCE_SUBCOMMANDS, new ArrayList(ALLIANCE_SUBCOMMANDS.size()));
                if (list.size() == 0) {
                    List<String> list2 = CommandUtils.getOnlinePlayerNames(commandSender);
                    return (List)StringUtil.copyPartialMatches((String)stringArray[0], list2, new ArrayList(list2.size()));
                }
                return list;
            }
        }
        return ImmutableList.of();
    }

    private void displayPartyHeader() {
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Header"));
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Ally", this.playerParty.getName(), this.targetParty.getName()));
    }

    private void displayMemberInfo(McMMOPlayer mcMMOPlayer) {
        List<Player> list = PartyManager.getNearMembers(mcMMOPlayer);
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Members.Header"));
        this.player.sendMessage(this.playerParty.createMembersList(this.player));
        this.player.sendMessage(ChatColor.DARK_GRAY + "----------------------------");
        this.player.sendMessage(this.targetParty.createMembersList(this.player));
    }
}

