/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyXpShareCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        Party party = UserManager.getPlayer((Player)commandSender).getParty();
        if (party.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.XP_SHARE)) {
            commandSender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.5"));
            return true;
        }
        switch (stringArray.length) {
            case 2: {
                if (stringArray[1].equalsIgnoreCase("none") || CommandUtils.shouldDisableToggle(stringArray[1])) {
                    this.handleChangingShareMode(party, ShareMode.NONE);
                } else if (stringArray[1].equalsIgnoreCase("equal") || stringArray[1].equalsIgnoreCase("even") || CommandUtils.shouldEnableToggle(stringArray[1])) {
                    this.handleChangingShareMode(party, ShareMode.EQUAL);
                } else {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "xpshare", "<NONE | EQUAL>"));
                }
                return true;
            }
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "xpshare", "<NONE | EQUAL>"));
        return true;
    }

    private void handleChangingShareMode(Party party, ShareMode shareMode) {
        party.setXpShareMode(shareMode);
        String string = LocaleLoader.getString("Commands.Party.SetSharing", LocaleLoader.getString("Party.ShareType.Xp"), LocaleLoader.getString("Party.ShareMode." + StringUtils.getCapitalized(shareMode.toString())));
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(string);
        }
    }
}

