/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class PartyLockCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                if (stringArray[0].equalsIgnoreCase("lock")) {
                    this.togglePartyLock(commandSender, true);
                } else if (stringArray[0].equalsIgnoreCase("unlock")) {
                    this.togglePartyLock(commandSender, false);
                }
                return true;
            }
            case 2: {
                if (!stringArray[0].equalsIgnoreCase("lock")) {
                    this.sendUsageStrings(commandSender);
                    return true;
                }
                if (CommandUtils.shouldEnableToggle(stringArray[1])) {
                    this.togglePartyLock(commandSender, true);
                } else if (CommandUtils.shouldDisableToggle(stringArray[1])) {
                    this.togglePartyLock(commandSender, false);
                } else {
                    this.sendUsageStrings(commandSender);
                }
                return true;
            }
        }
        this.sendUsageStrings(commandSender);
        return true;
    }

    private void sendUsageStrings(CommandSender commandSender) {
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "lock", "[on|off]"));
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.1", "party", "unlock"));
    }

    private void togglePartyLock(CommandSender commandSender, boolean bl) {
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return;
        }
        Party party = UserManager.getPlayer((Player)commandSender).getParty();
        if (!Permissions.partySubcommand((Permissible)commandSender, bl ? PartySubcommandType.LOCK : PartySubcommandType.UNLOCK)) {
            commandSender.sendMessage(LocaleLoader.getString("mcMMO.NoPermission"));
            return;
        }
        if (bl ? party.isLocked() : !party.isLocked()) {
            commandSender.sendMessage(LocaleLoader.getString("Party." + (bl ? "IsLocked" : "IsntLocked")));
            return;
        }
        party.setLocked(bl);
        commandSender.sendMessage(LocaleLoader.getString("Party." + (bl ? "Locked" : "Unlocked")));
    }
}

