/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyJoinCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 2: 
            case 3: {
                String string2 = CommandUtils.getMatchedPlayerName(stringArray[1]);
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(string2);
                if (!CommandUtils.checkPlayerExistence(commandSender, string2, mcMMOPlayer)) {
                    return true;
                }
                Player player = mcMMOPlayer.getPlayer();
                if (!mcMMOPlayer.inParty()) {
                    commandSender.sendMessage(LocaleLoader.getString("Party.PlayerNotInParty", string2));
                    return true;
                }
                Player player2 = (Player)commandSender;
                if (UserManager.getPlayer((Player)commandSender) == null) {
                    commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                    return true;
                }
                McMMOPlayer mcMMOPlayer2 = UserManager.getPlayer(player2);
                Party party = mcMMOPlayer.getParty();
                if (player2.equals(player) || mcMMOPlayer2.inParty() && mcMMOPlayer2.getParty().equals(party)) {
                    commandSender.sendMessage(LocaleLoader.getString("Party.Join.Self"));
                    return true;
                }
                String string3 = this.getPassword(stringArray);
                if (!PartyManager.checkPartyPassword(player2, party, string3)) {
                    return true;
                }
                String string4 = party.getName();
                if (!PartyManager.changeOrJoinParty(mcMMOPlayer2, string4)) {
                    return true;
                }
                if (PartyManager.isPartyFull(player2, party)) {
                    player2.sendMessage(LocaleLoader.getString("Commands.Party.PartyFull", party.toString()));
                    return true;
                }
                player2.sendMessage(LocaleLoader.getString("Commands.Party.Join", string4));
                PartyManager.addToParty(mcMMOPlayer2, party);
                return true;
            }
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.3", "party", "join", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">", "[" + LocaleLoader.getString("Commands.Usage.Password") + "]"));
        return true;
    }

    private String getPassword(String[] stringArray) {
        if (stringArray.length == 3) {
            return stringArray[2];
        }
        return null;
    }
}

