/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyItemShareCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        Party party = UserManager.getPlayer((Player)commandSender).getParty();
        if (party.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.ITEM_SHARE)) {
            commandSender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.4"));
            return true;
        }
        switch (stringArray.length) {
            case 2: {
                ShareMode shareMode = ShareMode.getShareMode(stringArray[1].toUpperCase());
                if (shareMode == null) {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "itemshare", "<NONE | EQUAL | RANDOM>"));
                    return true;
                }
                this.handleChangingShareMode(party, shareMode);
                return true;
            }
            case 3: {
                boolean bl;
                if (CommandUtils.shouldEnableToggle(stringArray[2])) {
                    bl = true;
                } else if (CommandUtils.shouldDisableToggle(stringArray[2])) {
                    bl = false;
                } else {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "itemshare", "<loot | mining | herbalism | woodcutting | misc> <true | false>"));
                    return true;
                }
                try {
                    this.handleToggleItemShareCategory(party, ItemShareType.valueOf(stringArray[1].toUpperCase()), bl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "itemshare", "<loot | mining | herbalism | woodcutting | misc> <true | false>"));
                }
                return true;
            }
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "itemshare", "<NONE | EQUAL | RANDOM>"));
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "itemshare", "<loot | mining | herbalism | woodcutting | misc> <true | false>"));
        return true;
    }

    private void handleChangingShareMode(Party party, ShareMode shareMode) {
        party.setItemShareMode(shareMode);
        String string = LocaleLoader.getString("Commands.Party.SetSharing", LocaleLoader.getString("Party.ShareType.Item"), LocaleLoader.getString("Party.ShareMode." + StringUtils.getCapitalized(shareMode.toString())));
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(string);
        }
    }

    private void handleToggleItemShareCategory(Party party, ItemShareType itemShareType, boolean bl) {
        party.setSharingDrops(itemShareType, bl);
        String string = LocaleLoader.getString("Commands.Party.ToggleShareCategory", StringUtils.getCapitalized(itemShareType.toString()), bl ? "enabled" : "disabled");
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(string);
        }
    }
}

