/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyInfoCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 0: 
            case 1: {
                if (UserManager.getPlayer((Player)commandSender) == null) {
                    commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                    return true;
                }
                Player player = (Player)commandSender;
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
                Party party = mcMMOPlayer.getParty();
                this.displayPartyHeader(player, party);
                this.displayShareModeInfo(player, party);
                this.displayPartyFeatures(player, party);
                this.displayMemberInfo(player, mcMMOPlayer, party);
                return true;
            }
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.1", "party", "info"));
        return true;
    }

    private void displayPartyHeader(Player player, Party party) {
        player.sendMessage(LocaleLoader.getString("Commands.Party.Header"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LocaleLoader.getString("Commands.Party.Status", party.getName(), LocaleLoader.getString("Party.Status." + (party.isLocked() ? "Locked" : "Unlocked")), party.getLevel()));
        if (!party.hasReachedLevelCap()) {
            stringBuilder.append(" (").append(party.getXpToLevelPercentage()).append(")");
        }
        player.sendMessage(stringBuilder.toString());
    }

    private void displayPartyFeatures(Player player, Party party) {
        player.sendMessage(LocaleLoader.getString("Commands.Party.Features.Header"));
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PartyFeature partyFeature : PartyFeature.values()) {
            if (!partyFeature.hasPermission(player)) continue;
            if (this.isUnlockedFeature(party, partyFeature)) {
                arrayList.add(partyFeature.getLocaleString());
                continue;
            }
            arrayList2.add(partyFeature.getFeatureLockedLocaleString());
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.UnlockedFeatures", arrayList.isEmpty() ? "None" : arrayList));
        for (String string : arrayList2) {
            player.sendMessage(string);
        }
    }

    private boolean isUnlockedFeature(Party party, PartyFeature partyFeature) {
        return party.getLevel() >= Config.getInstance().getPartyFeatureUnlockLevel(partyFeature);
    }

    private void displayShareModeInfo(Player player, Party party) {
        boolean bl;
        boolean bl2 = this.isUnlockedFeature(party, PartyFeature.XP_SHARE);
        boolean bl3 = this.isUnlockedFeature(party, PartyFeature.ITEM_SHARE);
        boolean bl4 = bl = party.getItemShareMode() != ShareMode.NONE;
        if (!bl2 && !bl3) {
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        if (bl2) {
            string = LocaleLoader.getString("Commands.Party.ExpShare", party.getXpShareMode().toString());
        }
        if (bl3) {
            string2 = LocaleLoader.getString("Commands.Party.ItemShare", party.getItemShareMode().toString());
        }
        if (bl2 && bl3) {
            string3 = ChatColor.DARK_GRAY + " || ";
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.ShareMode") + string + string3 + string2);
        if (bl) {
            player.sendMessage(LocaleLoader.getString("Commands.Party.ItemShareCategories", party.getItemShareCategories()));
        }
    }

    private void displayMemberInfo(Player player, McMMOPlayer mcMMOPlayer, Party party) {
        List<Player> list = PartyManager.getNearVisibleMembers(mcMMOPlayer);
        int n = party.getVisibleMembers(player).size();
        player.sendMessage(LocaleLoader.getString("Commands.Party.Members.Header"));
        player.sendMessage(LocaleLoader.getString("Commands.Party.MembersNear", list.size() + 1, n));
        player.sendMessage(party.createMembersList(player));
    }
}

