/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.commands.chat.PartyChatCommand;
import com.gmail.nossr50.commands.party.PartyAcceptCommand;
import com.gmail.nossr50.commands.party.PartyChangeOwnerCommand;
import com.gmail.nossr50.commands.party.PartyChangePasswordCommand;
import com.gmail.nossr50.commands.party.PartyCreateCommand;
import com.gmail.nossr50.commands.party.PartyDisbandCommand;
import com.gmail.nossr50.commands.party.PartyHelpCommand;
import com.gmail.nossr50.commands.party.PartyInfoCommand;
import com.gmail.nossr50.commands.party.PartyInviteCommand;
import com.gmail.nossr50.commands.party.PartyItemShareCommand;
import com.gmail.nossr50.commands.party.PartyJoinCommand;
import com.gmail.nossr50.commands.party.PartyKickCommand;
import com.gmail.nossr50.commands.party.PartyLockCommand;
import com.gmail.nossr50.commands.party.PartyQuitCommand;
import com.gmail.nossr50.commands.party.PartyRenameCommand;
import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.commands.party.PartyXpShareCommand;
import com.gmail.nossr50.commands.party.alliance.PartyAllianceCommand;
import com.gmail.nossr50.commands.party.teleport.PtpCommand;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class PartyCommand
implements TabExecutor {
    private static final List<String> PARTY_SUBCOMMANDS;
    private static final List<String> XPSHARE_COMPLETIONS;
    private static final List<String> ITEMSHARE_COMPLETIONS;
    private CommandExecutor partyJoinCommand = new PartyJoinCommand();
    private CommandExecutor partyAcceptCommand = new PartyAcceptCommand();
    private CommandExecutor partyCreateCommand = new PartyCreateCommand();
    private CommandExecutor partyQuitCommand = new PartyQuitCommand();
    private CommandExecutor partyXpShareCommand = new PartyXpShareCommand();
    private CommandExecutor partyItemShareCommand = new PartyItemShareCommand();
    private CommandExecutor partyInviteCommand = new PartyInviteCommand();
    private CommandExecutor partyKickCommand = new PartyKickCommand();
    private CommandExecutor partyDisbandCommand = new PartyDisbandCommand();
    private CommandExecutor partyChangeOwnerCommand = new PartyChangeOwnerCommand();
    private CommandExecutor partyLockCommand = new PartyLockCommand();
    private CommandExecutor partyChangePasswordCommand = new PartyChangePasswordCommand();
    private CommandExecutor partyRenameCommand = new PartyRenameCommand();
    private CommandExecutor partyInfoCommand = new PartyInfoCommand();
    private CommandExecutor partyHelpCommand = new PartyHelpCommand();
    private CommandExecutor partyTeleportCommand = new PtpCommand();
    private CommandExecutor partyChatCommand = new PartyChatCommand();
    private CommandExecutor partyAllianceCommand = new PartyAllianceCommand();

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (CommandUtils.noConsoleUsage(commandSender)) {
            return true;
        }
        if (!Permissions.party((Permissible)commandSender)) {
            commandSender.sendMessage(command.getPermissionMessage());
            return true;
        }
        Player player = (Player)commandSender;
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return true;
        }
        if (UserManager.getPlayer(player) == null) {
            player.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (stringArray.length < 1) {
            if (!mcMMOPlayer.inParty()) {
                commandSender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
                return this.printUsage(player);
            }
            return this.partyInfoCommand.onCommand(commandSender, command, string, stringArray);
        }
        PartySubcommandType partySubcommandType = PartySubcommandType.getSubcommand(stringArray[0]);
        if (partySubcommandType == null) {
            return this.printUsage(player);
        }
        if (partySubcommandType != PartySubcommandType.LOCK && partySubcommandType != PartySubcommandType.UNLOCK && !Permissions.partySubcommand((Permissible)commandSender, partySubcommandType)) {
            commandSender.sendMessage(command.getPermissionMessage());
            return true;
        }
        switch (partySubcommandType) {
            case JOIN: {
                return this.partyJoinCommand.onCommand(commandSender, command, string, stringArray);
            }
            case ACCEPT: {
                return this.partyAcceptCommand.onCommand(commandSender, command, string, stringArray);
            }
            case CREATE: {
                return this.partyCreateCommand.onCommand(commandSender, command, string, stringArray);
            }
            case HELP: {
                return this.partyHelpCommand.onCommand(commandSender, command, string, stringArray);
            }
        }
        if (!mcMMOPlayer.inParty()) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
            return this.printUsage(player);
        }
        switch (partySubcommandType) {
            case INFO: {
                return this.partyInfoCommand.onCommand(commandSender, command, string, stringArray);
            }
            case QUIT: {
                return this.partyQuitCommand.onCommand(commandSender, command, string, stringArray);
            }
            case INVITE: {
                return this.partyInviteCommand.onCommand(commandSender, command, string, stringArray);
            }
            case TELEPORT: {
                return this.partyTeleportCommand.onCommand(commandSender, command, string, this.extractArgs(stringArray));
            }
            case CHAT: {
                return this.partyChatCommand.onCommand(commandSender, command, string, this.extractArgs(stringArray));
            }
        }
        if (!mcMMOPlayer.getParty().getLeader().getUniqueId().equals(player.getUniqueId())) {
            commandSender.sendMessage(LocaleLoader.getString("Party.NotOwner"));
            return true;
        }
        switch (partySubcommandType) {
            case XPSHARE: {
                return this.partyXpShareCommand.onCommand(commandSender, command, string, stringArray);
            }
            case ITEMSHARE: {
                return this.partyItemShareCommand.onCommand(commandSender, command, string, stringArray);
            }
            case KICK: {
                return this.partyKickCommand.onCommand(commandSender, command, string, stringArray);
            }
            case DISBAND: {
                return this.partyDisbandCommand.onCommand(commandSender, command, string, stringArray);
            }
            case OWNER: {
                return this.partyChangeOwnerCommand.onCommand(commandSender, command, string, stringArray);
            }
            case LOCK: 
            case UNLOCK: {
                return this.partyLockCommand.onCommand(commandSender, command, string, stringArray);
            }
            case PASSWORD: {
                return this.partyChangePasswordCommand.onCommand(commandSender, command, string, stringArray);
            }
            case RENAME: {
                return this.partyRenameCommand.onCommand(commandSender, command, string, stringArray);
            }
            case ALLIANCE: {
                return this.partyAllianceCommand.onCommand(commandSender, command, string, stringArray);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], PARTY_SUBCOMMANDS, new ArrayList(PARTY_SUBCOMMANDS.size()));
            }
            case 2: {
                PartySubcommandType partySubcommandType = PartySubcommandType.getSubcommand(stringArray[0]);
                if (partySubcommandType == null) {
                    return ImmutableList.of();
                }
                switch (partySubcommandType) {
                    case JOIN: 
                    case INVITE: 
                    case KICK: 
                    case OWNER: {
                        List<String> list = CommandUtils.getOnlinePlayerNames(commandSender);
                        return (List)StringUtil.copyPartialMatches((String)stringArray[1], list, new ArrayList(list.size()));
                    }
                    case XPSHARE: {
                        return (List)StringUtil.copyPartialMatches((String)stringArray[1], XPSHARE_COMPLETIONS, new ArrayList(XPSHARE_COMPLETIONS.size()));
                    }
                    case ITEMSHARE: {
                        return (List)StringUtil.copyPartialMatches((String)stringArray[1], ITEMSHARE_COMPLETIONS, new ArrayList(ITEMSHARE_COMPLETIONS.size()));
                    }
                    case CHAT: 
                    case LOCK: {
                        return (List)StringUtil.copyPartialMatches((String)stringArray[1], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
                    }
                    case PASSWORD: {
                        return (List)StringUtil.copyPartialMatches((String)stringArray[1], CommandUtils.RESET_OPTIONS, new ArrayList(CommandUtils.RESET_OPTIONS.size()));
                    }
                    case TELEPORT: {
                        List list = (List)StringUtil.copyPartialMatches((String)stringArray[1], PtpCommand.TELEPORT_SUBCOMMANDS, new ArrayList(PtpCommand.TELEPORT_SUBCOMMANDS.size()));
                        if (list.size() == 0) {
                            Player player = (Player)commandSender;
                            if (UserManager.getPlayer(player) == null) {
                                commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                                return ImmutableList.of();
                            }
                            Party party = UserManager.getPlayer(player).getParty();
                            List<String> list2 = party.getOnlinePlayerNames((CommandSender)player);
                            return (List)StringUtil.copyPartialMatches((String)stringArray[1], list2, new ArrayList(list2.size()));
                        }
                        return list;
                    }
                }
                return ImmutableList.of();
            }
            case 3: {
                if (PartySubcommandType.getSubcommand(stringArray[0]) == PartySubcommandType.ITEMSHARE && this.isItemShareCategory(stringArray[1])) {
                    return (List)StringUtil.copyPartialMatches((String)stringArray[2], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
                }
                return ImmutableList.of();
            }
        }
        return ImmutableList.of();
    }

    private boolean printUsage(Player player) {
        player.sendMessage(LocaleLoader.getString("Party.Help.0", "/party join"));
        player.sendMessage(LocaleLoader.getString("Party.Help.1", "/party create"));
        player.sendMessage(LocaleLoader.getString("Party.Help.2", "/party ?"));
        return true;
    }

    private String[] extractArgs(String[] stringArray) {
        return Arrays.copyOfRange(stringArray, 1, stringArray.length);
    }

    private boolean isItemShareCategory(String string) {
        return string.equalsIgnoreCase("loot") || string.equalsIgnoreCase("mining") || string.equalsIgnoreCase("herbalism") || string.equalsIgnoreCase("woodcutting") || string.equalsIgnoreCase("misc");
    }

    static {
        XPSHARE_COMPLETIONS = ImmutableList.of((Object)"none", (Object)"equal");
        ITEMSHARE_COMPLETIONS = ImmutableList.of((Object)"none", (Object)"equal", (Object)"random", (Object)"loot", (Object)"mining", (Object)"herbalism", (Object)"woodcutting", (Object)"misc");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PartySubcommandType partySubcommandType : PartySubcommandType.values()) {
            arrayList.add(partySubcommandType.toString());
        }
        Collections.sort(arrayList);
        PARTY_SUBCOMMANDS = ImmutableList.copyOf(arrayList);
    }
}

