/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyChangePasswordCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (UserManager.getPlayer((Player)commandSender) == null) {
            commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        Party party = UserManager.getPlayer((Player)commandSender).getParty();
        switch (stringArray.length) {
            case 1: {
                this.unprotectParty(party, commandSender);
                return true;
            }
            case 2: {
                if (stringArray[1].equalsIgnoreCase("clear") || stringArray[1].equalsIgnoreCase("reset")) {
                    this.unprotectParty(party, commandSender);
                    return true;
                }
                this.protectParty(party, commandSender, stringArray[1]);
                return true;
            }
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "password", "[clear|reset]"));
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "password", "<" + LocaleLoader.getString("Commands.Usage.Password") + ">"));
        return true;
    }

    private void unprotectParty(Party party, CommandSender commandSender) {
        party.setLocked(true);
        party.setPassword(null);
        commandSender.sendMessage(LocaleLoader.getString("Party.Password.Removed"));
    }

    private void protectParty(Party party, CommandSender commandSender, String string) {
        party.setLocked(true);
        party.setPassword(string);
        commandSender.sendMessage(LocaleLoader.getString("Party.Password.Set", string));
    }
}

