/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyAcceptCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                Player player = (Player)commandSender;
                if (UserManager.getPlayer(player) == null) {
                    commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                    return true;
                }
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
                if (!mcMMOPlayer.hasPartyInvite()) {
                    commandSender.sendMessage(LocaleLoader.getString("mcMMO.NoInvites"));
                    return true;
                }
                if (!PartyManager.changeOrJoinParty(mcMMOPlayer, mcMMOPlayer.getPartyInvite().getName())) {
                    return true;
                }
                PartyManager.joinInvitedParty(mcMMOPlayer);
                return true;
            }
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Usage.1", "party", "accept"));
        return true;
    }
}

