/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.hardcore;

import com.gmail.nossr50.commands.hardcore.HardcoreModeCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class VampirismCommand
extends HardcoreModeCommand {
    @Override
    protected boolean checkTogglePermissions(CommandSender commandSender) {
        return Permissions.vampirismToggle((Permissible)commandSender);
    }

    @Override
    protected boolean checkModifyPermissions(CommandSender commandSender) {
        return Permissions.vampirismModify((Permissible)commandSender);
    }

    @Override
    protected boolean checkEnabled(PrimarySkillType primarySkillType) {
        if (primarySkillType == null) {
            for (PrimarySkillType primarySkillType2 : PrimarySkillType.values()) {
                if (primarySkillType2.getHardcoreVampirismEnabled()) continue;
                return false;
            }
            return true;
        }
        return primarySkillType.getHardcoreVampirismEnabled();
    }

    @Override
    protected void enable(PrimarySkillType primarySkillType) {
        this.toggle(true, primarySkillType);
    }

    @Override
    protected void disable(PrimarySkillType primarySkillType) {
        this.toggle(false, primarySkillType);
    }

    @Override
    protected void modify(CommandSender commandSender, double d) {
        Config.getInstance().setHardcoreVampirismStatLeechPercentage(d);
        commandSender.sendMessage(LocaleLoader.getString("Hardcore.Vampirism.PercentageChanged", this.percent.format(d / 100.0)));
    }

    private void toggle(boolean bl, PrimarySkillType primarySkillType) {
        if (primarySkillType == null) {
            for (PrimarySkillType primarySkillType2 : PrimarySkillType.NON_CHILD_SKILLS) {
                primarySkillType2.setHardcoreVampirismEnabled(bl);
            }
        } else {
            primarySkillType.setHardcoreVampirismEnabled(bl);
        }
        mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Hardcore.Mode." + (bl ? "Enabled" : "Disabled"), LocaleLoader.getString("Hardcore.Vampirism.Name"), primarySkillType == null ? "all skills" : primarySkillType));
    }
}

