/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.hardcore;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public abstract class HardcoreModeCommand
implements TabExecutor {
    protected final DecimalFormat percent = new DecimalFormat("##0.00%");

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                if (!this.checkTogglePermissions(commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (this.checkEnabled(null)) {
                    this.disable(null);
                } else {
                    this.enable(null);
                }
                return true;
            }
            case 1: {
                if (CommandUtils.shouldEnableToggle(stringArray[0])) {
                    if (!Permissions.hardcoreToggle((Permissible)commandSender)) {
                        commandSender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.enable(null);
                    return true;
                }
                if (CommandUtils.shouldDisableToggle(stringArray[0])) {
                    if (!Permissions.hardcoreToggle((Permissible)commandSender)) {
                        commandSender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.disable(null);
                    return true;
                }
                if (CommandUtils.isInvalidDouble(commandSender, stringArray[0])) {
                    return true;
                }
                if (!Permissions.hardcoreModify((Permissible)commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                this.modify(commandSender, Double.parseDouble(stringArray[0]));
                return true;
            }
            case 2: {
                if (CommandUtils.isInvalidSkill(commandSender, stringArray[0])) {
                    return true;
                }
                PrimarySkillType primarySkillType = PrimarySkillType.getSkill(stringArray[0]);
                if (!CommandUtils.isChildSkill(commandSender, primarySkillType)) {
                    return true;
                }
                if (CommandUtils.shouldEnableToggle(stringArray[1])) {
                    if (!Permissions.hardcoreToggle((Permissible)commandSender)) {
                        commandSender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.enable(primarySkillType);
                    return true;
                }
                if (CommandUtils.shouldDisableToggle(stringArray[1])) {
                    if (!Permissions.hardcoreToggle((Permissible)commandSender)) {
                        commandSender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.enable(primarySkillType);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                if (StringUtils.isDouble(stringArray[0])) {
                    return ImmutableList.of();
                }
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
            }
        }
        return ImmutableList.of();
    }

    protected abstract boolean checkTogglePermissions(CommandSender var1);

    protected abstract boolean checkModifyPermissions(CommandSender var1);

    protected abstract boolean checkEnabled(PrimarySkillType var1);

    protected abstract void enable(PrimarySkillType var1);

    protected abstract void disable(PrimarySkillType var1);

    protected abstract void modify(CommandSender var1, double var2);
}

