/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class SkillresetCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                if (CommandUtils.noConsoleUsage(commandSender)) {
                    return true;
                }
                if (!this.permissionsCheckSelf(commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(commandSender, stringArray[0])) {
                    return true;
                }
                PrimarySkillType primarySkillType = stringArray[0].equalsIgnoreCase("all") ? null : PrimarySkillType.getSkill(stringArray[1]);
                this.editValues((Player)commandSender, UserManager.getPlayer(commandSender.getName()).getProfile(), primarySkillType);
                return true;
            }
            case 2: {
                if (!this.permissionsCheckOthers(commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(commandSender, stringArray[1])) {
                    return true;
                }
                PrimarySkillType primarySkillType = stringArray[1].equalsIgnoreCase("all") ? null : PrimarySkillType.getSkill(stringArray[1]);
                String string2 = CommandUtils.getMatchedPlayerName(stringArray[0]);
                McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(string2);
                if (mcMMOPlayer == null) {
                    PlayerProfile playerProfile;
                    UUID uUID = null;
                    OfflinePlayer offlinePlayer = mcMMO.p.getServer().getOfflinePlayer(string2);
                    if (offlinePlayer != null) {
                        uUID = offlinePlayer.getUniqueId();
                    }
                    if (CommandUtils.unloadedProfile(commandSender, playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(string2, uUID, false))) {
                        return true;
                    }
                    this.editValues(null, playerProfile, primarySkillType);
                } else {
                    this.editValues(mcMMOPlayer.getPlayer(), mcMMOPlayer.getProfile(), primarySkillType);
                }
                SkillresetCommand.handleSenderMessage(commandSender, string2, primarySkillType);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                List<String> list = CommandUtils.getOnlinePlayerNames(commandSender);
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], list, new ArrayList(list.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[1], PrimarySkillType.SKILL_NAMES, new ArrayList(PrimarySkillType.SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    protected void handleCommand(Player player, PlayerProfile playerProfile, PrimarySkillType primarySkillType) {
        int n = playerProfile.getSkillLevel(primarySkillType);
        float f = playerProfile.getSkillXpLevelRaw(primarySkillType);
        playerProfile.modifySkill(primarySkillType, 0);
        if (player == null) {
            playerProfile.scheduleAsyncSave();
            return;
        }
        EventUtils.tryLevelChangeEvent(player, primarySkillType, n, f, false, XPGainReason.COMMAND);
    }

    protected boolean permissionsCheckSelf(CommandSender commandSender) {
        return Permissions.skillreset((Permissible)commandSender);
    }

    protected boolean permissionsCheckOthers(CommandSender commandSender) {
        return Permissions.skillresetOthers((Permissible)commandSender);
    }

    protected void handlePlayerMessageAll(Player player) {
        player.sendMessage(LocaleLoader.getString("Commands.Reset.All"));
    }

    protected void handlePlayerMessageSkill(Player player, PrimarySkillType primarySkillType) {
        player.sendMessage(LocaleLoader.getString("Commands.Reset.Single", primarySkillType.getName()));
    }

    private boolean validateArguments(CommandSender commandSender, String string) {
        return string.equalsIgnoreCase("all") || !CommandUtils.isInvalidSkill(commandSender, string);
    }

    protected static void handleSenderMessage(CommandSender commandSender, String string, PrimarySkillType primarySkillType) {
        if (primarySkillType == null) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardAll.2", string));
        } else {
            commandSender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardSkill.2", primarySkillType.getName(), string));
        }
    }

    protected void editValues(Player player, PlayerProfile playerProfile, PrimarySkillType primarySkillType) {
        if (primarySkillType == null) {
            for (PrimarySkillType primarySkillType2 : PrimarySkillType.NON_CHILD_SKILLS) {
                this.handleCommand(player, playerProfile, primarySkillType2);
            }
            if (player != null) {
                this.handlePlayerMessageAll(player);
            }
        } else {
            this.handleCommand(player, playerProfile, primarySkillType);
            if (player != null) {
                this.handlePlayerMessageSkill(player, primarySkillType);
            }
        }
    }
}

