/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public abstract class ExperienceCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 2: {
                if (CommandUtils.noConsoleUsage(commandSender)) {
                    return true;
                }
                if (!this.permissionsCheckSelf(commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(commandSender, stringArray[0], stringArray[1])) {
                    return true;
                }
                PrimarySkillType primarySkillType = PrimarySkillType.getSkill(stringArray[0]);
                if (stringArray[1].equalsIgnoreCase("all")) {
                    primarySkillType = null;
                }
                if (primarySkillType != null && primarySkillType.isChildSkill()) {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Skill.ChildSkill"));
                    return true;
                }
                if (UserManager.getPlayer(commandSender.getName()) == null) {
                    commandSender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                    return true;
                }
                this.editValues((Player)commandSender, UserManager.getPlayer(commandSender.getName()).getProfile(), primarySkillType, Integer.parseInt(stringArray[1]));
                return true;
            }
            case 3: {
                if (!this.permissionsCheckOthers(commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(commandSender, stringArray[1], stringArray[2])) {
                    return true;
                }
                PrimarySkillType primarySkillType = PrimarySkillType.getSkill(stringArray[1]);
                if (stringArray[1].equalsIgnoreCase("all")) {
                    primarySkillType = null;
                }
                if (primarySkillType != null && primarySkillType.isChildSkill()) {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Skill.ChildSkill"));
                    return true;
                }
                int n = Integer.parseInt(stringArray[2]);
                String string2 = CommandUtils.getMatchedPlayerName(stringArray[0]);
                McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(string2);
                if (mcMMOPlayer == null) {
                    PlayerProfile playerProfile;
                    UUID uUID = null;
                    OfflinePlayer offlinePlayer = mcMMO.p.getServer().getOfflinePlayer(string2);
                    if (offlinePlayer != null) {
                        uUID = offlinePlayer.getUniqueId();
                    }
                    if (CommandUtils.unloadedProfile(commandSender, playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(string2, uUID, false))) {
                        return true;
                    }
                    this.editValues(null, playerProfile, primarySkillType, n);
                } else {
                    this.editValues(mcMMOPlayer.getPlayer(), mcMMOPlayer.getProfile(), primarySkillType, n);
                }
                ExperienceCommand.handleSenderMessage(commandSender, string2, primarySkillType);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                List<String> list = CommandUtils.getOnlinePlayerNames(commandSender);
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], list, new ArrayList(list.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[1], PrimarySkillType.SKILL_NAMES, new ArrayList(PrimarySkillType.SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    protected abstract boolean permissionsCheckSelf(CommandSender var1);

    protected abstract boolean permissionsCheckOthers(CommandSender var1);

    protected abstract void handleCommand(Player var1, PlayerProfile var2, PrimarySkillType var3, int var4);

    protected abstract void handlePlayerMessageAll(Player var1, int var2);

    protected abstract void handlePlayerMessageSkill(Player var1, int var2, PrimarySkillType var3);

    private boolean validateArguments(CommandSender commandSender, String string, String string2) {
        return !CommandUtils.isInvalidInteger(commandSender, string2) && (string.equalsIgnoreCase("all") || !CommandUtils.isInvalidSkill(commandSender, string));
    }

    protected static void handleSenderMessage(CommandSender commandSender, String string, PrimarySkillType primarySkillType) {
        if (primarySkillType == null) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardAll.2", string));
        } else {
            commandSender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardSkill.2", primarySkillType.getName(), string));
        }
    }

    protected void editValues(Player player, PlayerProfile playerProfile, PrimarySkillType primarySkillType, int n) {
        if (primarySkillType == null) {
            for (PrimarySkillType primarySkillType2 : PrimarySkillType.NON_CHILD_SKILLS) {
                this.handleCommand(player, playerProfile, primarySkillType2, n);
            }
            if (player != null) {
                this.handlePlayerMessageAll(player, n);
            }
        } else {
            this.handleCommand(player, playerProfile, primarySkillType, n);
            if (player != null) {
                this.handlePlayerMessageSkill(player, n, primarySkillType);
            }
        }
    }
}

