/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.database.FormulaConversionTask;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConvertExperienceCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 2: {
                FormulaType formulaType = mcMMO.getFormulaManager().getPreviousFormulaType();
                FormulaType formulaType2 = FormulaType.getFormulaType(stringArray[1].toUpperCase());
                if (formulaType2 == FormulaType.UNKNOWN) {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Experience.Invalid"));
                    return true;
                }
                if (formulaType == formulaType2) {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Experience.Same", formulaType2.toString()));
                    return true;
                }
                commandSender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Experience.Start", formulaType.toString(), formulaType2.toString()));
                UserManager.saveAll();
                UserManager.clearAll();
                new FormulaConversionTask(commandSender, formulaType2).runTaskLater((Plugin)mcMMO.p, 1L);
                for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
                    new PlayerProfileLoadingTask(player).runTaskLaterAsynchronously((Plugin)mcMMO.p, 1L);
                }
                return true;
            }
        }
        return false;
    }
}

