/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.commands.experience.ExperienceCommand;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AddxpCommand
extends ExperienceCommand {
    @Override
    protected boolean permissionsCheckSelf(CommandSender commandSender) {
        return Permissions.addxp((Permissible)commandSender);
    }

    @Override
    protected boolean permissionsCheckOthers(CommandSender commandSender) {
        return Permissions.addxpOthers((Permissible)commandSender);
    }

    @Override
    protected void handleCommand(Player player, PlayerProfile playerProfile, PrimarySkillType primarySkillType, int n) {
        if (player != null) {
            if (UserManager.getPlayer(player) == null) {
                return;
            }
            UserManager.getPlayer(player).applyXpGain(primarySkillType, n, XPGainReason.COMMAND, XPGainSource.COMMAND);
        } else {
            playerProfile.addXp(primarySkillType, n);
            playerProfile.scheduleAsyncSave();
        }
    }

    @Override
    protected void handlePlayerMessageAll(Player player, int n) {
        player.sendMessage(LocaleLoader.getString("Commands.addxp.AwardAll", n));
    }

    @Override
    protected void handlePlayerMessageSkill(Player player, int n, PrimarySkillType primarySkillType) {
        player.sendMessage(LocaleLoader.getString("Commands.addxp.AwardSkill", n, primarySkillType.getName()));
    }
}

