/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.database;

import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.database.DatabaseManagerFactory;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.database.DatabaseConversionTask;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConvertDatabaseCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 2: {
                DatabaseType databaseType = DatabaseType.getDatabaseType(stringArray[1]);
                DatabaseType databaseType2 = mcMMO.getDatabaseManager().getDatabaseType();
                if (databaseType == databaseType2 || databaseType2 == DatabaseType.CUSTOM && DatabaseManagerFactory.getCustomDatabaseManagerClass().getSimpleName().equalsIgnoreCase(stringArray[1])) {
                    commandSender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Database.Same", databaseType2.toString()));
                    return true;
                }
                DatabaseManager databaseManager = DatabaseManagerFactory.createDatabaseManager(databaseType);
                if (databaseType == DatabaseType.CUSTOM) {
                    try {
                        Class<?> clazz = Class.forName(stringArray[1]);
                        if (!DatabaseManager.class.isAssignableFrom(clazz)) {
                            commandSender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Database.InvalidType", stringArray[1]));
                            return true;
                        }
                        databaseManager = DatabaseManagerFactory.createCustomDatabaseManager(clazz);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        commandSender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Database.InvalidType", stringArray[1]));
                        return true;
                    }
                }
                commandSender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Database.Start", databaseType.toString(), databaseType2.toString()));
                UserManager.saveAll();
                UserManager.clearAll();
                for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
                    PlayerProfile playerProfile = databaseManager.loadPlayerProfile(player.getUniqueId());
                    if (playerProfile.isLoaded()) {
                        mcMMO.getDatabaseManager().saveUser(playerProfile);
                    }
                    new PlayerProfileLoadingTask(player).runTaskLaterAsynchronously((Plugin)mcMMO.p, 1L);
                }
                new DatabaseConversionTask(databaseManager, commandSender, databaseType.toString(), databaseType2.toString()).runTaskAsynchronously((Plugin)mcMMO.p);
                return true;
            }
        }
        return false;
    }
}

