/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.chat;

import com.gmail.nossr50.chat.PartyChatManager;
import com.gmail.nossr50.commands.chat.ChatCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyChatCommand
extends ChatCommand {
    public PartyChatCommand() {
        super(ChatMode.PARTY);
    }

    @Override
    protected void handleChatSending(CommandSender commandSender, String[] stringArray) {
        String string;
        Party party;
        if (commandSender instanceof Player) {
            if (UserManager.getPlayer((Player)commandSender) == null) {
                return;
            }
            party = UserManager.getPlayer((Player)commandSender).getParty();
            if (party == null) {
                commandSender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
                return;
            }
            if (party.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.CHAT)) {
                commandSender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.1"));
                return;
            }
            string = this.buildChatMessage(stringArray, 0);
        } else {
            if (stringArray.length < 2) {
                commandSender.sendMessage(LocaleLoader.getString("Party.Specify"));
                return;
            }
            party = PartyManager.getParty(stringArray[0]);
            if (party == null) {
                commandSender.sendMessage(LocaleLoader.getString("Party.InvalidName"));
                return;
            }
            string = this.buildChatMessage(stringArray, 1);
        }
        ((PartyChatManager)this.chatManager).setParty(party);
        this.chatManager.handleChat(commandSender.getName(), this.getDisplayName(commandSender), string);
    }
}

