/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.chat;

import com.gmail.nossr50.chat.ChatManager;
import com.gmail.nossr50.chat.ChatManagerFactory;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public abstract class ChatCommand
implements TabExecutor {
    private ChatMode chatMode;
    protected ChatManager chatManager;

    public ChatCommand(ChatMode chatMode) {
        this.chatMode = chatMode;
        this.chatManager = ChatManagerFactory.getChatManager((Plugin)mcMMO.p, chatMode);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                if (CommandUtils.noConsoleUsage(commandSender)) {
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(commandSender)) {
                    return true;
                }
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(commandSender.getName());
                if (mcMMOPlayer.isChatEnabled(this.chatMode)) {
                    this.disableChatMode(mcMMOPlayer, commandSender);
                } else {
                    this.enableChatMode(mcMMOPlayer, commandSender);
                }
                return true;
            }
            case 1: {
                if (CommandUtils.shouldEnableToggle(stringArray[0])) {
                    if (CommandUtils.noConsoleUsage(commandSender)) {
                        return true;
                    }
                    if (!CommandUtils.hasPlayerDataKey(commandSender)) {
                        return true;
                    }
                    this.enableChatMode(UserManager.getPlayer(commandSender.getName()), commandSender);
                    return true;
                }
                if (!CommandUtils.shouldDisableToggle(stringArray[0])) break;
                if (CommandUtils.noConsoleUsage(commandSender)) {
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(commandSender)) {
                    return true;
                }
                this.disableChatMode(UserManager.getPlayer(commandSender.getName()), commandSender);
                return true;
            }
        }
        this.handleChatSending(commandSender, stringArray);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
            }
        }
        return ImmutableList.of();
    }

    protected String buildChatMessage(String[] stringArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[n]);
        for (int i = n + 1; i < stringArray.length; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    protected String getDisplayName(CommandSender commandSender) {
        return commandSender instanceof Player ? ((Player)commandSender).getDisplayName() : LocaleLoader.getString("Commands.Chat.Console");
    }

    protected abstract void handleChatSending(CommandSender var1, String[] var2);

    private void enableChatMode(McMMOPlayer mcMMOPlayer, CommandSender commandSender) {
        if (this.chatMode == ChatMode.PARTY && mcMMOPlayer.getParty() == null) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
            return;
        }
        if (this.chatMode == ChatMode.PARTY && mcMMOPlayer.getParty().getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.CHAT)) {
            commandSender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.1"));
            return;
        }
        mcMMOPlayer.enableChat(this.chatMode);
        commandSender.sendMessage(this.chatMode.getEnabledMessage());
    }

    private void disableChatMode(McMMOPlayer mcMMOPlayer, CommandSender commandSender) {
        if (this.chatMode == ChatMode.PARTY && mcMMOPlayer.getParty() == null) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
            return;
        }
        mcMMOPlayer.disableChat(this.chatMode);
        commandSender.sendMessage(this.chatMode.getDisabledMessage());
    }
}

