/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.notifications.SensitiveCommandType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class XprateCommand
implements TabExecutor {
    private final double ORIGINAL_XP_RATE = ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier();

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                if (!stringArray[0].equalsIgnoreCase("reset") && !stringArray[0].equalsIgnoreCase("clear")) {
                    return false;
                }
                if (!Permissions.xprateReset((Permissible)commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (mcMMO.p.isXPEventEnabled()) {
                    if (AdvancedConfig.getInstance().useTitlesForXPEvent()) {
                        NotificationManager.broadcastTitle(mcMMO.p.getServer(), LocaleLoader.getString("Commands.Event.Stop"), LocaleLoader.getString("Commands.Event.Stop.Subtitle"), 10, 200, 20);
                    }
                    if (Config.getInstance().broadcastEventMessages()) {
                        mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Commands.Event.Stop"));
                        mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Commands.Event.Stop.Subtitle"));
                    }
                    NotificationManager.processSensitiveCommandNotification(commandSender, SensitiveCommandType.XPRATE_END, new String[0]);
                    mcMMO.p.toggleXpEventEnabled();
                }
                ExperienceConfig.getInstance().setExperienceGainsGlobalMultiplier(this.ORIGINAL_XP_RATE);
                return true;
            }
            case 2: {
                if (CommandUtils.isInvalidInteger(commandSender, stringArray[0])) {
                    return true;
                }
                if (!Permissions.xprateSet((Permissible)commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (CommandUtils.shouldDisableToggle(stringArray[1])) {
                    mcMMO.p.setXPEventEnabled(false);
                } else if (CommandUtils.shouldEnableToggle(stringArray[1])) {
                    mcMMO.p.setXPEventEnabled(true);
                } else {
                    return false;
                }
                int n = Integer.parseInt(stringArray[0]);
                if (n < 0) {
                    commandSender.sendMessage(ChatColor.RED + LocaleLoader.getString("Commands.NegativeNumberWarn"));
                    return true;
                }
                ExperienceConfig.getInstance().setExperienceGainsGlobalMultiplier(n);
                if (AdvancedConfig.getInstance().useTitlesForXPEvent()) {
                    NotificationManager.broadcastTitle(mcMMO.p.getServer(), LocaleLoader.getString("Commands.Event.Start"), LocaleLoader.getString("Commands.Event.XP", n), 10, 200, 20);
                }
                if (Config.getInstance().broadcastEventMessages()) {
                    mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Commands.Event.Start"));
                    mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Commands.Event.XP", n));
                }
                NotificationManager.processSensitiveCommandNotification(commandSender, SensitiveCommandType.XPRATE_MODIFY, String.valueOf(n));
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                if (StringUtils.isInt(stringArray[0])) {
                    return ImmutableList.of();
                }
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], CommandUtils.RESET_OPTIONS, new ArrayList(CommandUtils.RESET_OPTIONS.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[1], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
            }
        }
        return ImmutableList.of();
    }
}

