/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

public abstract class ToggleCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                if (CommandUtils.noConsoleUsage(commandSender)) {
                    return true;
                }
                if (!this.hasSelfPermission(commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(commandSender)) {
                    return true;
                }
                this.applyCommandAction(UserManager.getPlayer(commandSender.getName()));
                return true;
            }
            case 1: {
                McMMOPlayer mcMMOPlayer;
                if (!this.hasOtherPermission(commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                String string2 = CommandUtils.getMatchedPlayerName(stringArray[0]);
                if (!CommandUtils.checkPlayerExistence(commandSender, string2, mcMMOPlayer = UserManager.getPlayer(string2))) {
                    return true;
                }
                if (CommandUtils.isOffline(commandSender, (OfflinePlayer)mcMMOPlayer.getPlayer())) {
                    return true;
                }
                this.applyCommandAction(mcMMOPlayer);
                this.sendSuccessMessage(commandSender, string2);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                List<String> list = CommandUtils.getOnlinePlayerNames(commandSender);
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], list, new ArrayList(list.size()));
            }
        }
        return ImmutableList.of();
    }

    protected abstract boolean hasOtherPermission(CommandSender var1);

    protected abstract boolean hasSelfPermission(CommandSender var1);

    protected abstract void applyCommandAction(McMMOPlayer var1);

    protected abstract void sendSuccessMessage(CommandSender var1, String var2);
}

