/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

public class McscoreboardCommand
implements TabExecutor {
    private static final List<String> FIRST_ARGS = ImmutableList.of((Object)"keep", (Object)"time", (Object)"clear");

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (CommandUtils.noConsoleUsage(commandSender)) {
            return true;
        }
        switch (stringArray.length) {
            case 1: {
                if (stringArray[0].equalsIgnoreCase("clear") || stringArray[0].equalsIgnoreCase("reset")) {
                    ScoreboardManager.clearBoard(commandSender.getName());
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Clear"));
                    return true;
                }
                if (stringArray[0].equalsIgnoreCase("keep")) {
                    if (!Config.getInstance().getAllowKeepBoard() || !Config.getInstance().getScoreboardsEnabled()) {
                        commandSender.sendMessage(LocaleLoader.getString("Commands.Disabled"));
                        return true;
                    }
                    if (!ScoreboardManager.isBoardShown(commandSender.getName())) {
                        commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.NoBoard"));
                        return true;
                    }
                    ScoreboardManager.keepBoard(commandSender.getName());
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Keep"));
                    return true;
                }
                return this.help(commandSender);
            }
            case 2: {
                if (stringArray[0].equalsIgnoreCase("time") || stringArray[0].equalsIgnoreCase("timer")) {
                    if (CommandUtils.isInvalidInteger(commandSender, stringArray[1])) {
                        return true;
                    }
                    int n = Math.abs(Integer.parseInt(stringArray[1]));
                    ScoreboardManager.setRevertTimer(commandSender.getName(), n);
                    commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Timer", n));
                    return true;
                }
                return this.help(commandSender);
            }
        }
        return this.help(commandSender);
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], FIRST_ARGS, new ArrayList(FIRST_ARGS.size()));
            }
        }
        return ImmutableList.of();
    }

    private boolean help(CommandSender commandSender) {
        commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Help.0"));
        commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Help.1"));
        commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Help.2"));
        commandSender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Help.3"));
        return true;
    }
}

