/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class McmmoCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                if (!Permissions.mcmmoDescription((Permissible)commandSender)) {
                    commandSender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                String string2 = LocaleLoader.getString("mcMMO.Description");
                String[] stringArray2 = string2.split(",");
                commandSender.sendMessage(stringArray2);
                commandSender.sendMessage(LocaleLoader.getString("mcMMO.Description.FormerDevs"));
                if (Config.getInstance().getDonateMessageEnabled()) {
                    commandSender.sendMessage(LocaleLoader.getString("MOTD.Donate"));
                    commandSender.sendMessage(ChatColor.GOLD + " - " + ChatColor.GREEN + "nossr50@gmail.com" + ChatColor.GOLD + " Paypal");
                }
                if (Permissions.showversion((Permissible)commandSender)) {
                    commandSender.sendMessage(LocaleLoader.getString("MOTD.Version", mcMMO.p.getDescription().getVersion()));
                }
                mcMMO.getHolidayManager().anniversaryCheck(commandSender);
                return true;
            }
            case 1: {
                if (stringArray[0].equalsIgnoreCase("?") || stringArray[0].equalsIgnoreCase("help") || stringArray[0].equalsIgnoreCase("commands")) {
                    if (!Permissions.mcmmoHelp((Permissible)commandSender)) {
                        commandSender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    commandSender.sendMessage(LocaleLoader.getString("Commands.mcc.Header"));
                    this.displayGeneralCommands(commandSender);
                    this.displayOtherCommands(commandSender);
                    this.displayPartyCommands(commandSender);
                }
                return true;
            }
        }
        return false;
    }

    private void displayGeneralCommands(CommandSender commandSender) {
        commandSender.sendMessage(ChatColor.DARK_AQUA + " /mcstats " + LocaleLoader.getString("Commands.Stats"));
        commandSender.sendMessage(ChatColor.DARK_AQUA + " /<skill>" + LocaleLoader.getString("Commands.SkillInfo"));
        commandSender.sendMessage(ChatColor.DARK_AQUA + " /mctop " + LocaleLoader.getString("Commands.Leaderboards"));
        if (Permissions.inspect((Permissible)commandSender)) {
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /inspect " + LocaleLoader.getString("Commands.Inspect"));
        }
        if (Permissions.mcability((Permissible)commandSender)) {
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /mcability " + LocaleLoader.getString("Commands.ToggleAbility"));
        }
    }

    private void displayOtherCommands(CommandSender commandSender) {
        if (!(Permissions.skillreset((Permissible)commandSender) || Permissions.mmoedit((Permissible)commandSender) || Permissions.adminChat((Permissible)commandSender) || Permissions.mcgod((Permissible)commandSender))) {
            return;
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Other"));
        if (Permissions.skillreset((Permissible)commandSender)) {
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /skillreset <skill|all> " + LocaleLoader.getString("Commands.Reset"));
        }
        if (Permissions.mmoedit((Permissible)commandSender)) {
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /mmoedit " + LocaleLoader.getString("Commands.mmoedit"));
        }
        if (Permissions.adminChat((Permissible)commandSender)) {
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /adminchat " + LocaleLoader.getString("Commands.AdminToggle"));
        }
        if (Permissions.mcgod((Permissible)commandSender)) {
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /mcgod " + LocaleLoader.getString("Commands.mcgod"));
        }
    }

    private void displayPartyCommands(CommandSender commandSender) {
        if (Permissions.party((Permissible)commandSender)) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.Party.Commands"));
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /party create <" + LocaleLoader.getString("Commands.Usage.PartyName") + "> " + LocaleLoader.getString("Commands.Party1"));
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /party join <" + LocaleLoader.getString("Commands.Usage.Player") + "> " + LocaleLoader.getString("Commands.Party2"));
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /party quit " + LocaleLoader.getString("Commands.Party.Quit"));
            if (Permissions.partyChat((Permissible)commandSender)) {
                commandSender.sendMessage(ChatColor.DARK_AQUA + " /party chat " + LocaleLoader.getString("Commands.Party.Toggle"));
            }
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /party invite <" + LocaleLoader.getString("Commands.Usage.Player") + "> " + LocaleLoader.getString("Commands.Party.Invite"));
            commandSender.sendMessage(ChatColor.DARK_AQUA + " /party accept " + LocaleLoader.getString("Commands.Party.Accept"));
            if (Permissions.partySubcommand((Permissible)commandSender, PartySubcommandType.TELEPORT)) {
                commandSender.sendMessage(ChatColor.DARK_AQUA + " /party teleport <" + LocaleLoader.getString("Commands.Usage.Player") + "> " + LocaleLoader.getString("Commands.Party.Teleport"));
            }
        }
    }
}

