/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.commands.database.ConvertDatabaseCommand;
import com.gmail.nossr50.commands.experience.ConvertExperienceCommand;
import com.gmail.nossr50.database.DatabaseManagerFactory;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.mcMMO;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

public class McconvertCommand
implements TabExecutor {
    private static final List<String> FORMULA_TYPES;
    private static final List<String> DATABASE_TYPES;
    private static final List<String> SUBCOMMANDS;
    private CommandExecutor databaseConvertCommand = new ConvertDatabaseCommand();
    private CommandExecutor experienceConvertCommand = new ConvertExperienceCommand();

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 2: {
                if (stringArray[0].equalsIgnoreCase("database") || stringArray[0].equalsIgnoreCase("db")) {
                    return this.databaseConvertCommand.onCommand(commandSender, command, string, stringArray);
                }
                if (stringArray[0].equalsIgnoreCase("experience") || stringArray[0].equalsIgnoreCase("xp") || stringArray[1].equalsIgnoreCase("exp")) {
                    return this.experienceConvertCommand.onCommand(commandSender, command, string, stringArray);
                }
                return false;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], SUBCOMMANDS, new ArrayList(SUBCOMMANDS.size()));
            }
            case 2: {
                if (stringArray[0].equalsIgnoreCase("database") || stringArray[0].equalsIgnoreCase("db")) {
                    return (List)StringUtil.copyPartialMatches((String)stringArray[0], DATABASE_TYPES, new ArrayList(DATABASE_TYPES.size()));
                }
                if (stringArray[0].equalsIgnoreCase("experience") || stringArray[0].equalsIgnoreCase("xp") || stringArray[0].equalsIgnoreCase("exp")) {
                    return (List)StringUtil.copyPartialMatches((String)stringArray[0], FORMULA_TYPES, new ArrayList(FORMULA_TYPES.size()));
                }
                return ImmutableList.of();
            }
        }
        return ImmutableList.of();
    }

    static {
        SUBCOMMANDS = ImmutableList.of((Object)"database", (Object)"experience");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (FormulaType enum_ : FormulaType.values()) {
            arrayList.add(enum_.toString());
        }
        for (Enum enum_ : DatabaseType.values()) {
            arrayList2.add(enum_.toString());
        }
        arrayList2.remove(DatabaseType.CUSTOM.toString());
        if (mcMMO.getDatabaseManager().getDatabaseType() == DatabaseType.CUSTOM) {
            arrayList2.add(DatabaseManagerFactory.getCustomDatabaseManagerClass().getName());
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        FORMULA_TYPES = ImmutableList.copyOf(arrayList);
        DATABASE_TYPES = ImmutableList.copyOf(arrayList2);
    }
}

