/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.datatypes.skills.ModConfigType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class McImportCommand
implements CommandExecutor {
    int fileAmount;

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                this.importModConfig();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean importModConfig() {
        String string = mcMMO.getModDirectory() + File.separator + "import";
        File file = new File(string, "import.log");
        mcMMO.p.getLogger().info("Starting import of mod materials...");
        this.fileAmount = 0;
        HashMap<ModConfigType, ArrayList<String>> hashMap = new HashMap<ModConfigType, ArrayList<String>>();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                String[] stringArray2 = string2.split("material ");
                if (stringArray2.length != 2 || (stringArray = stringArray2[1].split(" with")).length != 2) continue;
                String string3 = stringArray[0];
                ModConfigType modConfigType = ModConfigType.getModConfigType(string3);
                if (!hashMap.containsKey((Object)modConfigType)) {
                    hashMap.put(modConfigType, new ArrayList());
                }
                hashMap.get((Object)modConfigType).add(string3);
            }
            this.tryClose(bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            mcMMO.p.getLogger().warning("Could not find " + file.getAbsolutePath() + " ! (No such file or directory)");
            mcMMO.p.getLogger().warning("Copy and paste latest.log to " + file.getParentFile().getAbsolutePath() + " and rename it to import.log");
            boolean bl = false;
            this.tryClose(bufferedReader);
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            this.tryClose(bufferedReader);
            return bl;
            {
                catch (Throwable throwable) {
                    this.tryClose(bufferedReader);
                    throw throwable;
                }
            }
        }
        this.createOutput(hashMap);
        mcMMO.p.getLogger().info("Import finished! Created " + this.fileAmount + " files!");
        return true;
    }

    private void createOutput(HashMap<ModConfigType, ArrayList<String>> hashMap) {
        for (ModConfigType modConfigType : hashMap.keySet()) {
            HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
            for (String string : hashMap.get((Object)modConfigType)) {
                String string2 = Misc.getModName(string);
                if (!hashMap2.containsKey(string2)) {
                    hashMap2.put(string2, new ArrayList());
                }
                hashMap2.get(string2).add(string);
            }
            this.createOutput(modConfigType, hashMap2);
        }
    }

    private void tryClose(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOutput(ModConfigType modConfigType, HashMap<String, ArrayList<String>> hashMap) {
        File file = new File(mcMMO.getModDirectory() + File.separator + "output");
        if (!file.exists() && !file.mkdirs()) {
            mcMMO.p.getLogger().severe("Could not create output directory! " + file.getAbsolutePath());
        }
        FileWriter fileWriter = null;
        String string = modConfigType.name().toLowerCase();
        for (String string2 : hashMap.keySet()) {
            File file2 = new File(file, string2 + "." + string + ".yml");
            mcMMO.p.getLogger().info("Creating " + file2.getName());
            try {
                if (file2.exists() && !file2.delete()) {
                    mcMMO.p.getLogger().severe("Not able to delete old output file! " + file2.getAbsolutePath());
                }
                if (!file2.createNewFile()) {
                    mcMMO.p.getLogger().severe("Could not create output file! " + file2.getAbsolutePath());
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                HashMap<String, ArrayList<String>> hashMap2 = this.getConfigSections(modConfigType, string2, hashMap);
                if (hashMap2 == null) {
                    mcMMO.p.getLogger().severe("Something went wrong!! type is " + string);
                    this.tryClose(fileWriter);
                    ++this.fileAmount;
                    return;
                }
                for (String string3 : hashMap2.keySet()) {
                    if (string3.equals("UNIDENTIFIED")) {
                        stringBuilder.append("# This isn't a valid config section and all materials in this category need to be").append("\r\n");
                        stringBuilder.append("# copy and pasted to a valid section of this config file.").append("\r\n");
                    }
                    stringBuilder.append(string3).append(":").append("\r\n");
                    for (String string4 : hashMap2.get(string3)) {
                        stringBuilder.append(string4).append("\r\n");
                    }
                    stringBuilder.append("\r\n");
                }
                fileWriter = new FileWriter(file2);
                fileWriter.write(stringBuilder.toString());
                this.tryClose(fileWriter);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            finally {
                this.tryClose(fileWriter);
                ++this.fileAmount;
                continue;
            }
            ++this.fileAmount;
        }
    }

    private HashMap<String, ArrayList<String>> getConfigSections(ModConfigType modConfigType, String string, HashMap<String, ArrayList<String>> hashMap) {
        switch (modConfigType) {
            case BLOCKS: {
                return this.getConfigSectionsBlocks(string, hashMap);
            }
            case TOOLS: {
                return this.getConfigSectionsTools(string, hashMap);
            }
            case ARMOR: {
                return this.getConfigSectionsArmor(string, hashMap);
            }
            case UNKNOWN: {
                return this.getConfigSectionsUnknown(string, hashMap);
            }
        }
        return null;
    }

    private HashMap<String, ArrayList<String>> getConfigSectionsBlocks(String string, HashMap<String, ArrayList<String>> hashMap) {
        HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
        for (String string2 : hashMap.get(string)) {
            String string3 = "UNIDENTIFIED";
            if (string2.contains("ORE")) {
                string3 = "Mining";
            } else if (string2.contains("LOG") || string2.contains("LEAVES")) {
                string3 = "Woodcutting";
            } else if (string2.contains("GRASS") || string2.contains("FLOWER") || string2.contains("CROP")) {
                string3 = "Herbalism";
            } else if (string2.contains("DIRT") || string2.contains("SAND")) {
                string3 = "Excavation";
            }
            if (!hashMap2.containsKey(string3)) {
                hashMap2.put(string3, new ArrayList());
            }
            ArrayList<String> arrayList = hashMap2.get(string3);
            arrayList.add("    " + string2 + "|0:");
            arrayList.add("        XP_Gain: 99");
            arrayList.add("        Double_Drops_Enabled: true");
            if (string3.equals("Mining")) {
                arrayList.add("        Smelting_XP_Gain: 9");
                continue;
            }
            if (!string3.equals("Woodcutting")) continue;
            arrayList.add("        Is_Log: " + string2.contains("LOG"));
        }
        return hashMap2;
    }

    private HashMap<String, ArrayList<String>> getConfigSectionsTools(String string, HashMap<String, ArrayList<String>> hashMap) {
        HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
        for (String string2 : hashMap.get(string)) {
            String string3 = "UNIDENTIFIED";
            if (string2.contains("PICKAXE")) {
                string3 = "Pickaxes";
            } else if (string2.contains("AXE")) {
                string3 = "Axes";
            } else if (string2.contains("BOW")) {
                string3 = "Bows";
            } else if (string2.contains("HOE")) {
                string3 = "Hoes";
            } else if (string2.contains("SHOVEL") || string2.contains("SPADE")) {
                string3 = "Shovels";
            } else if (string2.contains("SWORD")) {
                string3 = "Swords";
            }
            if (!hashMap2.containsKey(string3)) {
                hashMap2.put(string3, new ArrayList());
            }
            ArrayList<String> arrayList = hashMap2.get(string3);
            arrayList.add("    " + string2 + ":");
            arrayList.add("        XP_Modifier: 1.0");
            arrayList.add("        Tier: 1");
            arrayList.add("        Ability_Enabled: true");
            this.addRepairableLines(string2, arrayList);
        }
        return hashMap2;
    }

    private HashMap<String, ArrayList<String>> getConfigSectionsArmor(String string, HashMap<String, ArrayList<String>> hashMap) {
        HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
        for (String string2 : hashMap.get(string)) {
            String string3 = "UNIDENTIFIED";
            if (string2.contains("BOOT") || string2.contains("SHOE")) {
                string3 = "Boots";
            } else if (string2.contains("CHESTPLATE") || string2.contains("CHEST")) {
                string3 = "Chestplates";
            } else if (string2.contains("HELM") || string2.contains("HAT")) {
                string3 = "Helmets";
            } else if (string2.contains("LEGGINGS") || string2.contains("LEGS") || string2.contains("PANTS")) {
                string3 = "Leggings";
            }
            if (!hashMap2.containsKey(string3)) {
                hashMap2.put(string3, new ArrayList());
            }
            ArrayList<String> arrayList = hashMap2.get(string3);
            arrayList.add("    " + string2 + ":");
            this.addRepairableLines(string2, arrayList);
        }
        return hashMap2;
    }

    private void addRepairableLines(String string, ArrayList<String> arrayList) {
        arrayList.add("        Repairable: true");
        arrayList.add("        Repair_Material: REPAIR_MATERIAL_NAME");
        arrayList.add("        Repair_Material_Data_Value: 0");
        arrayList.add("        Repair_Material_Quantity: 9");
        arrayList.add("        Repair_Material_Pretty_Name: Repair Item Name");
        arrayList.add("        Repair_MinimumLevel: 0");
        arrayList.add("        Repair_XpMultiplier: 1.0");
        Material material = Material.matchMaterial((String)string);
        int n = material == null ? 9999 : (int)material.getMaxDurability();
        arrayList.add("        Durability: " + (n > 0 ? n : 9999));
    }

    private HashMap<String, ArrayList<String>> getConfigSectionsUnknown(String string, HashMap<String, ArrayList<String>> hashMap) {
        HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
        for (String string2 : hashMap.get(string)) {
            String string3 = "UNIDENTIFIED";
            if (!hashMap2.containsKey(string3)) {
                hashMap2.put(string3, new ArrayList());
            }
            ArrayList<String> arrayList = hashMap2.get(string3);
            arrayList.add("    " + string2);
        }
        return hashMap2;
    }
}

